/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.lang.reflect.Array;
import java.util.Set;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;

public class MBeanDumper {
    private static final Log log = LogFactory.getLog(MBeanDumper.class);
    private static final String CRLF = "\r\n";

    public static String dumpBeans(MBeanServer mbeanServer, Set<ObjectName> names) {
        StringBuilder buf = new StringBuilder();
        for (ObjectName oname : names) {
            buf.append("Name: ");
            buf.append(oname.toString());
            buf.append(CRLF);
            try {
                MBeanInfo minfo = mbeanServer.getMBeanInfo(oname);
                String code = minfo.getClassName();
                if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                    code = (String)mbeanServer.getAttribute(oname, "modelerType");
                }
                buf.append("modelerType: ");
                buf.append(code);
                buf.append(CRLF);
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                Object value = null;
                for (int i = 0; i < attrs.length; ++i) {
                    String attName;
                    if (!attrs[i].isReadable() || "modelerType".equals(attName = attrs[i].getName()) || attName.indexOf(61) >= 0 || attName.indexOf(58) >= 0 || attName.indexOf(32) >= 0) continue;
                    try {
                        value = mbeanServer.getAttribute(oname, attName);
                    }
                    catch (JMRuntimeException rme) {
                        Throwable cause = rme.getCause();
                        if (cause instanceof UnsupportedOperationException) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Error getting attribute " + oname + " " + attName), (Throwable)rme);
                            continue;
                        }
                        if (cause instanceof NullPointerException) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Error getting attribute " + oname + " " + attName), (Throwable)rme);
                            continue;
                        }
                        log.error((Object)("Error getting attribute " + oname + " " + attName), (Throwable)rme);
                        continue;
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                        log.error((Object)("Error getting attribute " + oname + " " + attName), t);
                        continue;
                    }
                    if (value == null) continue;
                    try {
                        String valueString;
                        Class<?> c = value.getClass();
                        if (c.isArray()) {
                            int len = Array.getLength(value);
                            StringBuilder sb = new StringBuilder("Array[" + c.getComponentType().getName() + "] of length " + len);
                            if (len > 0) {
                                sb.append(CRLF);
                            }
                            for (int j = 0; j < len; ++j) {
                                sb.append("\t");
                                Object item = Array.get(value, j);
                                if (item == null) {
                                    sb.append("NULL VALUE");
                                } else {
                                    try {
                                        sb.append(MBeanDumper.escape(item.toString()));
                                    }
                                    catch (Throwable t) {
                                        ExceptionUtils.handleThrowable(t);
                                        sb.append("NON-STRINGABLE VALUE");
                                    }
                                }
                                if (j >= len - 1) continue;
                                sb.append(CRLF);
                            }
                            valueString = sb.toString();
                        } else {
                            valueString = MBeanDumper.escape(value.toString());
                        }
                        buf.append(attName);
                        buf.append(": ");
                        buf.append(valueString);
                        buf.append(CRLF);
                        continue;
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
            }
            buf.append(CRLF);
        }
        return buf.toString();
    }

    public static String escape(String value) {
        int idx = value.indexOf("\n");
        if (idx < 0) {
            return value;
        }
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        while (idx >= 0) {
            MBeanDumper.appendHead(sb, value, prev, idx);
            sb.append("\\n\n ");
            prev = idx + 1;
            if (idx == value.length() - 1) break;
            idx = value.indexOf(10, idx + 1);
        }
        if (prev < value.length()) {
            MBeanDumper.appendHead(sb, value, prev, value.length());
        }
        return sb.toString();
    }

    private static void appendHead(StringBuilder sb, String value, int start, int end) {
        if (end < 1) {
            return;
        }
        int pos = start;
        while (end - pos > 78) {
            sb.append(value.substring(pos, pos + 78));
            sb.append("\n ");
            pos += 78;
        }
        sb.append(value.substring(pos, end));
    }
}

