/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.WebConnection;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProcessor<S>
implements Processor<S>,
WebConnection {
    protected static final StringManager sm = StringManager.getManager("org.apache.coyote.http11.upgrade");
    private final UpgradeToken upgradeToken;
    private final AbstractServletInputStream upgradeServletInputStream;
    private final AbstractServletOutputStream<S> upgradeServletOutputStream;

    protected abstract Log getLog();

    protected AbstractProcessor(UpgradeToken upgradeToken, AbstractServletInputStream upgradeServletInputStream, AbstractServletOutputStream<S> upgradeServletOutputStream) {
        this.upgradeToken = upgradeToken;
        this.upgradeServletInputStream = upgradeServletInputStream;
        this.upgradeServletOutputStream = upgradeServletOutputStream;
    }

    @Override
    public void close() throws Exception {
        this.upgradeServletInputStream.close();
        this.upgradeServletOutputStream.close();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return this.upgradeServletInputStream;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this.upgradeServletOutputStream;
    }

    @Override
    public final boolean isUpgrade() {
        return true;
    }

    @Override
    public UpgradeToken getUpgradeToken() {
        return this.upgradeToken;
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketStatus status) throws IOException {
        if (status == SocketStatus.OPEN_READ) {
            this.upgradeServletInputStream.onDataAvailable();
        } else if (status == SocketStatus.OPEN_WRITE) {
            this.upgradeServletOutputStream.onWritePossible();
        } else {
            if (status == SocketStatus.STOP) {
                try {
                    this.upgradeServletInputStream.close();
                }
                catch (IOException ioe) {
                    this.getLog().debug((Object)sm.getString("abstractProcessor.isCloseFail", ioe));
                }
                try {
                    this.upgradeServletOutputStream.close();
                }
                catch (IOException ioe) {
                    this.getLog().debug((Object)sm.getString("abstractProcessor.osCloseFail", ioe));
                }
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            if (status == SocketStatus.DISCONNECT) {
                this.upgradeServletInputStream.onError(new IOException(sm.getString("abstractProcessor.clientAbort")));
            } else {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
        }
        if (this.upgradeServletInputStream.isCloseRequired() || this.upgradeServletOutputStream.isCloseRequired()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.UPGRADED;
    }

    @Override
    public final void recycle(boolean socketClosing) {
    }

    @Override
    public final Executor getExecutor() {
        return null;
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> socketWrapper) throws IOException {
        return null;
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        return null;
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) {
        return null;
    }

    @Override
    public void errorDispatch() {
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        return null;
    }

    @Override
    public final boolean isComet() {
        return false;
    }

    @Override
    public final boolean isAsync() {
        return false;
    }

    @Override
    public final Request getRequest() {
        return null;
    }

    @Override
    public final void setSslSupport(SSLSupport sslSupport) {
    }

    @Override
    public ByteBuffer getLeftoverInput() {
        return null;
    }
}

