/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.util.res.StringManager;

public class HttpMessages {
    private static final Map<Locale, HttpMessages> instances = new ConcurrentHashMap<Locale, HttpMessages>();
    private static final HttpMessages DEFAULT = new HttpMessages(StringManager.getManager("org.apache.tomcat.util.http.res", Locale.getDefault()));
    private final StringManager sm;
    private final String st_200;
    private final String st_302;
    private final String st_400;
    private final String st_404;

    private HttpMessages(StringManager sm) {
        this.sm = sm;
        this.st_200 = sm.getString("sc.200");
        this.st_302 = sm.getString("sc.302");
        this.st_400 = sm.getString("sc.400");
        this.st_404 = sm.getString("sc.404");
    }

    public String getMessage(int status) {
        switch (status) {
            case 200: {
                return this.st_200;
            }
            case 302: {
                return this.st_302;
            }
            case 400: {
                return this.st_400;
            }
            case 404: {
                return this.st_404;
            }
        }
        return this.sm.getString("sc." + status);
    }

    public static HttpMessages getInstance(Locale locale) {
        HttpMessages result = instances.get(locale);
        if (result == null) {
            StringManager sm = StringManager.getManager("org.apache.tomcat.util.http.res", locale);
            result = Locale.getDefault().equals(sm.getLocale()) ? DEFAULT : new HttpMessages(sm);
            instances.put(locale, result);
        }
        return result;
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static boolean isSafeInHttpHeader(String msg) {
        if (msg == null) {
            return true;
        }
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            char c = msg.charAt(i);
            if (' ' <= c && c <= '~' || '\u0080' <= c && c <= '\u00ff' || c == '\t') continue;
            return false;
        }
        return true;
    }
}

