/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apdplat.word.corpus.Bigram;
import org.apdplat.word.recognition.RecognitionTool;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class MinimalWordCount
extends AbstractSegmentation {
    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.MinimalWordCount;
    }

    @Override
    public List<Word> segImpl(String string) {
        int n2 = string.length();
        Node node = new Node("S", 0);
        node.score = Float.valueOf(1.0f);
        Node node2 = new Node("END", n2 + 1);
        Node[][] nodeArray = new Node[n2 + 2][0];
        nodeArray[0] = new Node[]{node};
        nodeArray[n2 + 1] = new Node[]{node2};
        if (this.isParallelSeg()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add(i);
            }
            arrayList.parallelStream().forEach(n -> {
                nodeArray[n.intValue() + 1] = this.fullSeg(string, (int)n);
            });
        } else {
            for (int i = 0; i < n2; ++i) {
                nodeArray[i + 1] = this.fullSeg(string, i);
            }
        }
        this.dumpDAG(nodeArray);
        int n3 = 0;
        Node node3 = null;
        for (int i = 0; i < nodeArray.length - 1; ++i) {
            for (int j = 0; j < nodeArray[i].length; ++j) {
                node3 = nodeArray[i][j];
                n3 = node3.getFollowing();
                for (int k = 0; k < nodeArray[n3].length; ++k) {
                    nodeArray[n3][k].setPrevious(node3);
                }
            }
        }
        this.dumpShortestPath(nodeArray);
        return this.toWords(node2);
    }

    private List<Word> toWords(Node node) {
        Stack<String> stack = new Stack<String>();
        while ((node = node.getPrevious()) != null) {
            if ("S".equals(node.getText())) continue;
            stack.push(node.getText());
        }
        int n = stack.size();
        ArrayList<Word> arrayList = new ArrayList<Word>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Word((String)stack.pop()));
        }
        return arrayList;
    }

    private Node[] fullSeg(String string, int n) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(new Node(string.substring(n, n + 1), n + 1));
        int n2 = string.length();
        int n3 = n2 - n;
        int n4 = this.getInterceptLength();
        if (n3 > n4) {
            n3 = n4;
        }
        while (n3 > 1) {
            if (this.getDictionary().contains(string, n, n3) || RecognitionTool.recog(string, n, n3)) {
                linkedList.add(new Node(string.substring(n, n + n3), n + 1));
            }
            --n3;
        }
        return linkedList.toArray(new Node[0]);
    }

    private void dumpShortestPath(Node[][] nodeArray) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6709\u5411\u65e0\u73af\u56fe\u7684\u6700\u4f73\u8def\u5f84\uff1a");
            for (Node[] nodeArray2 : nodeArray) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Node node : nodeArray2) {
                    stringBuilder.append("\u3010").append(node.getText()).append("(").append(node.getScore()).append(")").append("<-").append(node.getPrevious() == null ? "" : node.getPrevious().getText()).append("\u3011\t");
                }
                this.LOGGER.debug(stringBuilder.toString());
            }
        }
    }

    private void dumpDAG(Node[][] nodeArray) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6709\u5411\u65e0\u73af\u56fe\uff1a");
            for (int i = 0; i < nodeArray.length - 1; ++i) {
                Node[] nodeArray2 = nodeArray[i];
                StringBuilder stringBuilder = new StringBuilder();
                for (Node node : nodeArray2) {
                    int n = node.getFollowing();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (int j = 0; j < nodeArray[n].length; ++j) {
                        String string = nodeArray[n][j].getText();
                        stringBuilder2.append("(").append(string).append(")");
                    }
                    stringBuilder.append("\u3010").append(node.getText()).append("->").append(stringBuilder2.toString()).append("\u3011\t");
                }
                this.LOGGER.debug(stringBuilder.toString());
            }
        }
    }

    public static void main(String[] stringArray) {
        MinimalWordCount minimalWordCount = new MinimalWordCount();
        if (stringArray != null && stringArray.length > 0) {
            System.out.println(minimalWordCount.seg(Arrays.asList(stringArray).toString()));
            return;
        }
        System.out.println(minimalWordCount.seg("\u72ec\u7acb\u81ea\u4e3b\u548c\u5e73\u7b49\u4e92\u5229\u7684\u539f\u5219"));
        System.out.println(minimalWordCount.seg("\u6211\u7231\u695a\u79bb\u964c"));
    }

    private static class Node {
        private String text;
        private Node previous;
        private int offset;
        private Float score;

        public Node(String string, int n) {
            this.text = string;
            this.offset = n;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public Float getScore() {
            return this.score;
        }

        public void setScore(Float f) {
            this.score = f;
        }

        public Node getPrevious() {
            return this.previous;
        }

        public void setPrevious(Node node) {
            float f = 1.0f - Bigram.getScore(node.getText(), this.getText());
            if (this.score == null) {
                this.score = Float.valueOf(node.score.floatValue() + f);
                this.previous = node;
            } else if (node.score.floatValue() + f < this.score.floatValue()) {
                this.score = Float.valueOf(node.score.floatValue() + f);
                this.previous = node;
            }
        }

        public int getFollowing() {
            return this.offset + this.text.length();
        }

        public String toString() {
            return "Node{text='" + this.text + '\'' + ", previous=" + this.previous + ", offset=" + this.offset + ", score=" + this.score + '}';
        }
    }
}

