/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.Connection;
import com.subgraph.orchid.ConnectionCache;
import com.subgraph.orchid.ConnectionFailedException;
import com.subgraph.orchid.ConnectionHandshakeException;
import com.subgraph.orchid.ConnectionTimeoutException;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.CircuitCreationRequest;
import com.subgraph.orchid.circuits.CircuitExtender;
import com.subgraph.orchid.circuits.CircuitImpl;
import com.subgraph.orchid.circuits.TorInitializationTracker;
import com.subgraph.orchid.circuits.path.PathSelectionFailedException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CircuitBuildTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(CircuitBuildTask.class.getName());
    private final CircuitCreationRequest creationRequest;
    private final ConnectionCache connectionCache;
    private final TorInitializationTracker initializationTracker;
    private final CircuitImpl circuit;
    private final CircuitExtender extender;
    private Connection connection = null;

    public CircuitBuildTask(CircuitCreationRequest request, ConnectionCache connectionCache, boolean ntorEnabled) {
        this(request, connectionCache, ntorEnabled, null);
    }

    public CircuitBuildTask(CircuitCreationRequest request, ConnectionCache connectionCache, boolean ntorEnabled, TorInitializationTracker initializationTracker) {
        this.creationRequest = request;
        this.connectionCache = connectionCache;
        this.initializationTracker = initializationTracker;
        this.circuit = request.getCircuit();
        this.extender = new CircuitExtender(request.getCircuit(), ntorEnabled);
    }

    @Override
    public void run() {
        Router firstRouter = null;
        try {
            this.circuit.notifyCircuitBuildStart();
            this.creationRequest.choosePath();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Opening a new circuit to " + this.pathToString(this.creationRequest));
            }
            firstRouter = this.creationRequest.getPathElement(0);
            this.openEntryNodeConnection(firstRouter);
            this.buildCircuit(firstRouter);
            this.circuit.notifyCircuitBuildCompleted();
        }
        catch (ConnectionTimeoutException e) {
            this.connectionFailed("Timeout connecting to " + firstRouter);
        }
        catch (ConnectionFailedException e) {
            this.connectionFailed("Connection failed to " + firstRouter + " : " + e.getMessage());
        }
        catch (ConnectionHandshakeException e) {
            this.connectionFailed("Handshake error connecting to " + firstRouter + " : " + e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.circuitBuildFailed("Circuit building thread interrupted");
        }
        catch (PathSelectionFailedException e) {
            this.circuitBuildFailed(e.getMessage());
        }
        catch (TorException e) {
            this.circuitBuildFailed(e.getMessage());
        }
        catch (Exception e) {
            this.circuitBuildFailed("Unexpected exception: " + e);
            logger.log(Level.WARNING, "Unexpected exception while building circuit: " + e, e);
        }
    }

    private String pathToString(CircuitCreationRequest ccr) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Router r : ccr.getPath()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(r.getNickname());
        }
        sb.append("]");
        return sb.toString();
    }

    private void connectionFailed(String message) {
        this.creationRequest.connectionFailed(message);
        this.circuit.notifyCircuitBuildFailed();
    }

    private void circuitBuildFailed(String message) {
        this.creationRequest.circuitBuildFailed(message);
        this.circuit.notifyCircuitBuildFailed();
        if (this.connection != null) {
            this.connection.removeCircuit(this.circuit);
        }
    }

    private void openEntryNodeConnection(Router firstRouter) throws ConnectionTimeoutException, ConnectionFailedException, ConnectionHandshakeException, InterruptedException {
        this.connection = this.connectionCache.getConnectionTo(firstRouter, this.creationRequest.isDirectoryCircuit());
        this.circuit.bindToConnection(this.connection);
        this.creationRequest.connectionCompleted(this.connection);
    }

    private void buildCircuit(Router firstRouter) throws TorException {
        this.notifyInitialization();
        CircuitNode firstNode = this.extender.createFastTo(firstRouter);
        this.creationRequest.nodeAdded(firstNode);
        for (int i = 1; i < this.creationRequest.getPathLength(); ++i) {
            CircuitNode extendedNode = this.extender.extendTo(this.creationRequest.getPathElement(i));
            this.creationRequest.nodeAdded(extendedNode);
        }
        this.creationRequest.circuitBuildCompleted(this.circuit);
        this.notifyDone();
    }

    private void notifyInitialization() {
        if (this.initializationTracker != null) {
            int event = this.creationRequest.isDirectoryCircuit() ? 15 : 90;
            this.initializationTracker.notifyEvent(event);
        }
    }

    private void notifyDone() {
        if (this.initializationTracker != null && !this.creationRequest.isDirectoryCircuit()) {
            this.initializationTracker.notifyEvent(100);
        }
    }
}

