/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.OpenFailedException;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.StreamExitRequest;
import com.subgraph.orchid.data.IPv4Address;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;

public class PendingExitStreams {
    private final Set<StreamExitRequest> pendingRequests;
    private final Object lock = new Object();
    private final TorConfig config;

    PendingExitStreams(TorConfig config) {
        this.config = config;
        this.pendingRequests = new HashSet<StreamExitRequest>();
    }

    Stream openExitStream(IPv4Address address, int port) throws InterruptedException, OpenFailedException {
        StreamExitRequest request = new StreamExitRequest(this.lock, address, port);
        return this.openExitStreamByRequest(request);
    }

    Stream openExitStream(String hostname, int port) throws InterruptedException, OpenFailedException {
        StreamExitRequest request = new StreamExitRequest(this.lock, hostname, port);
        return this.openExitStreamByRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream openExitStreamByRequest(StreamExitRequest request) throws InterruptedException, OpenFailedException {
        if (this.config.getCircuitStreamTimeout() != 0L) {
            request.setStreamTimeout(this.config.getCircuitStreamTimeout());
        }
        Object object = this.lock;
        synchronized (object) {
            Stream stream;
            this.pendingRequests.add(request);
            try {
                stream = this.handleRequest(request);
                this.pendingRequests.remove(request);
            }
            catch (Throwable throwable) {
                this.pendingRequests.remove(request);
                throw throwable;
            }
            return stream;
        }
    }

    private Stream handleRequest(StreamExitRequest request) throws InterruptedException, OpenFailedException {
        while (true) {
            if (!request.isCompleted()) {
                this.lock.wait();
                continue;
            }
            try {
                return request.getStream();
            }
            catch (TimeoutException e) {
                request.resetForRetry();
                continue;
            }
            catch (StreamConnectFailedException e) {
                request.resetForRetry();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<StreamExitRequest> getUnreservedPendingRequests() {
        ArrayList<StreamExitRequest> result = new ArrayList<StreamExitRequest>();
        Object object = this.lock;
        synchronized (object) {
            for (StreamExitRequest request : this.pendingRequests) {
                if (request.isReserved()) continue;
                result.add(request);
            }
        }
        return result;
    }
}

