/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.path;

import com.subgraph.orchid.Router;
import com.subgraph.orchid.crypto.TorRandom;
import java.util.ArrayList;
import java.util.List;

public class BandwidthWeightedRouters {
    private static final long MAX_SCALE = 0x1FFFFFFFFFFFFFFFL;
    private static final double EPSILON = 0.1;
    private final List<WeightedRouter> weightedRouters = new ArrayList<WeightedRouter>();
    private final TorRandom random = new TorRandom();
    private double totalExitBw;
    private double totalNonExitBw;
    private double totalGuardBw;
    private boolean isScaled;
    private int unknownCount;

    void addRouter(Router router, double weightedBandwidth) {
        this.weightedRouters.add(new WeightedRouter(router, weightedBandwidth));
        this.adjustTotals(router, weightedBandwidth);
        this.isScaled = false;
    }

    boolean isTotalBandwidthZero() {
        return this.getTotalBandwidth() < 0.1;
    }

    double getTotalBandwidth() {
        return this.totalExitBw + this.totalNonExitBw;
    }

    double getTotalGuardBandwidth() {
        return this.totalGuardBw;
    }

    double getTotalExitBandwidth() {
        return this.totalExitBw;
    }

    private void adjustTotals(Router router, double bw) {
        if (router.isExit()) {
            this.totalExitBw += bw;
        } else {
            this.totalNonExitBw += bw;
        }
        if (router.isPossibleGuard()) {
            this.totalGuardBw += bw;
        }
    }

    void addRouterUnknown(Router router) {
        WeightedRouter wr = new WeightedRouter(router, 0.0);
        wr.isUnknown = true;
        this.weightedRouters.add(wr);
        ++this.unknownCount;
    }

    int getRouterCount() {
        return this.weightedRouters.size();
    }

    int getUnknownCount() {
        return this.unknownCount;
    }

    void fixUnknownValues() {
        if (this.unknownCount == 0) {
            return;
        }
        if (this.isTotalBandwidthZero()) {
            this.fixUnknownValues(40000L, 20000L);
        } else {
            int knownCount = this.weightedRouters.size() - this.unknownCount;
            long average = (long)(this.getTotalBandwidth() / (double)knownCount);
            this.fixUnknownValues(average, average);
        }
    }

    private void fixUnknownValues(long fastBw, long slowBw) {
        for (WeightedRouter wr : this.weightedRouters) {
            if (!wr.isUnknown) continue;
            long bw = wr.router.isFast() ? fastBw : slowBw;
            wr.weightedBandwidth = bw;
            wr.isUnknown = false;
            this.adjustTotals(wr.router, bw);
        }
        this.unknownCount = 0;
        this.isScaled = false;
    }

    Router chooseRandomRouterByWeight() {
        long total = this.getScaledTotal();
        if (total == 0L) {
            if (this.weightedRouters.size() == 0) {
                return null;
            }
            int idx = this.random.nextInt(this.weightedRouters.size());
            return this.weightedRouters.get(idx).router;
        }
        return this.chooseFirstElementAboveRandom(this.random.nextLong(total));
    }

    void adjustWeights(double exitWeight, double guardWeight) {
        for (WeightedRouter wr : this.weightedRouters) {
            WeightedRouter weightedRouter;
            Router r = wr.router;
            if (r.isExit() && r.isPossibleGuard()) {
                weightedRouter = wr;
                weightedRouter.weightedBandwidth = weightedRouter.weightedBandwidth * (exitWeight * guardWeight);
                continue;
            }
            if (r.isPossibleGuard()) {
                weightedRouter = wr;
                weightedRouter.weightedBandwidth = weightedRouter.weightedBandwidth * guardWeight;
                continue;
            }
            if (!r.isExit()) continue;
            weightedRouter = wr;
            weightedRouter.weightedBandwidth = weightedRouter.weightedBandwidth * exitWeight;
        }
        this.scaleRouterWeights();
    }

    private Router chooseFirstElementAboveRandom(long randomValue) {
        long sum = 0L;
        Router chosen = null;
        for (WeightedRouter wr : this.weightedRouters) {
            if ((sum += wr.scaledBandwidth) <= randomValue) continue;
            chosen = wr.router;
            randomValue = Long.MAX_VALUE;
        }
        if (chosen == null) {
            return this.weightedRouters.get(this.weightedRouters.size() - 1).router;
        }
        return chosen;
    }

    private double getWeightedTotal() {
        double total = 0.0;
        for (WeightedRouter wr : this.weightedRouters) {
            total += wr.weightedBandwidth;
        }
        return total;
    }

    private void scaleRouterWeights() {
        double scaleFactor = 2.305843009213694E18 / this.getWeightedTotal();
        for (WeightedRouter wr : this.weightedRouters) {
            wr.scaleBandwidth(scaleFactor);
        }
        this.isScaled = true;
    }

    private long getScaledTotal() {
        if (!this.isScaled) {
            this.scaleRouterWeights();
        }
        long total = 0L;
        for (WeightedRouter wr : this.weightedRouters) {
            total += wr.scaledBandwidth;
        }
        return total;
    }

    private static class WeightedRouter {
        private final Router router;
        private boolean isUnknown;
        private double weightedBandwidth;
        private long scaledBandwidth;

        WeightedRouter(Router router, double bw) {
            this.router = router;
            this.weightedBandwidth = bw;
        }

        void scaleBandwidth(double scaleFactor) {
            this.scaledBandwidth = Math.round(this.weightedBandwidth * scaleFactor);
        }
    }
}

