/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;

public class ConfigurationPropertyImpl
implements ConfigurationProperty {
    private int _order;
    private boolean _confidential;
    private String _name;
    private String _helpMessageKey;
    private String _displayMessageKey;
    private Object _value;
    private Class<?> _type;
    private Set<Class<? extends APIOperation>> _operations;
    private boolean _required;
    private transient ConfigurationPropertiesImpl _parent;

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public void setConfidential(boolean confidential) {
        this._confidential = confidential;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getHelpMessageKey() {
        return this._helpMessageKey;
    }

    public void setHelpMessageKey(String key) {
        this._helpMessageKey = key;
    }

    public String getDisplayMessageKey() {
        return this._displayMessageKey;
    }

    public void setDisplayMessageKey(String key) {
        this._displayMessageKey = key;
    }

    public void setType(Class<?> type) {
        this._type = type;
    }

    public ConfigurationPropertiesImpl getParent() {
        return this._parent;
    }

    public void setParent(ConfigurationPropertiesImpl parent) {
        this._parent = parent;
    }

    public Set<Class<? extends APIOperation>> getOperations() {
        return this._operations;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean v) {
        this._required = v;
    }

    public void setOperations(Set<Class<? extends APIOperation>> set) {
        this._operations = CollectionUtil.newReadOnlySet(set);
    }

    private String formatMessage(String key, String dflt, Object ... args) {
        APIConfigurationImpl apiConfig = this.getParent().getParent();
        ConnectorMessages messages = apiConfig.getConnectorInfo().getMessages();
        return messages.format(key, dflt, args);
    }

    public boolean isConfidential() {
        return this._confidential;
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String getHelpMessage(String def) {
        return this.formatMessage(this._helpMessageKey, def, new Object[0]);
    }

    public String getDisplayName(String def) {
        return this.formatMessage(this._displayMessageKey, def, new Object[0]);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigurationPropertyImpl) {
            ConfigurationPropertyImpl other = (ConfigurationPropertyImpl)o;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (!CollectionUtil.equals((Object)this.getValue(), (Object)other.getValue())) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            if (!CollectionUtil.equals((Object)this.getHelpMessageKey(), (Object)other.getHelpMessageKey())) {
                return false;
            }
            if (!CollectionUtil.equals((Object)this.getDisplayMessageKey(), (Object)other.getDisplayMessageKey())) {
                return false;
            }
            if (this.isConfidential() != other.isConfidential()) {
                return false;
            }
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            if (!CollectionUtil.equals(this.getType(), other.getType())) {
                return false;
            }
            return CollectionUtil.equals(this._operations, other._operations);
        }
        return false;
    }
}

