/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Level;
import org.ghost4j.GhostscriptException;
import org.ghost4j.GhostscriptLibrary;
import org.ghost4j.GhostscriptLoggerOutputStream;
import org.ghost4j.GhostscriptRevision;
import org.ghost4j.display.DisplayCallback;
import org.ghost4j.display.DisplayData;

public class Ghostscript {
    public static final String PROPERTY_NAME_ENCODING = "ghost4j.encoding";
    private static GhostscriptLibrary.gs_main_instance.ByReference nativeInstanceByRef;
    private static Ghostscript instance;
    private static InputStream stdIn;
    private static OutputStream stdOut;
    private static OutputStream stdErr;
    private static DisplayCallback displayCallback;
    private static DisplayData displayData;
    private static GhostscriptLibrary.display_callback_s nativeDisplayCallback;

    public static synchronized Ghostscript getInstance() {
        if (instance == null) {
            instance = new Ghostscript();
        }
        return instance;
    }

    public synchronized DisplayCallback getDisplayCallback() {
        return displayCallback;
    }

    public synchronized void setDisplayCallback(DisplayCallback displayCallback) {
        Ghostscript.displayCallback = displayCallback;
    }

    public synchronized OutputStream getStdErr() {
        return stdErr;
    }

    public synchronized void setStdErr(OutputStream stdErr) {
        Ghostscript.stdErr = stdErr;
    }

    public synchronized OutputStream getStdOut() {
        return stdOut;
    }

    public synchronized void setStdOut(OutputStream stdOut) {
        Ghostscript.stdOut = stdOut;
    }

    public synchronized InputStream getStdIn() {
        return stdIn;
    }

    public synchronized void setStdIn(InputStream stdIn) {
        Ghostscript.stdIn = stdIn;
    }

    private Ghostscript() {
    }

    private synchronized GhostscriptLibrary.gs_main_instance.ByReference getNativeInstanceByRef() throws GhostscriptException {
        int result;
        if (nativeInstanceByRef == null && (result = GhostscriptLibrary.instance.gsapi_new_instance((nativeInstanceByRef = new GhostscriptLibrary.gs_main_instance.ByReference()).getPointer(), null)) != 0) {
            nativeInstanceByRef = null;
            throw new GhostscriptException("Cannot get Ghostscript interpreter instance. Error code is " + result);
        }
        return nativeInstanceByRef;
    }

    private synchronized DisplayData getDisplayData() {
        if (displayData == null) {
            displayData = new DisplayData();
        }
        return displayData;
    }

    public static GhostscriptRevision getRevision() {
        GhostscriptLibrary.gsapi_revision_s revision = new GhostscriptLibrary.gsapi_revision_s();
        GhostscriptLibrary.instance.gsapi_revision(revision, revision.size());
        GhostscriptRevision result = new GhostscriptRevision();
        result.setProduct(revision.product);
        result.setCopyright(revision.copyright);
        result.setNumber(new Float(revision.revision.floatValue() / 100.0f).toString());
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            result.setRevisionDate(sdf.parse(revision.revisiondate.toString()));
        }
        catch (ParseException e) {
            result.setRevisionDate(null);
        }
        return result;
    }

    public void initialize(String[] args) throws GhostscriptException {
        int result = 0;
        GhostscriptLibrary.stdin_fn stdinCallback = null;
        if (this.getStdIn() != null) {
            stdinCallback = new GhostscriptLibrary.stdin_fn(){

                public int callback(Pointer caller_handle, Pointer buf, int len) {
                    String encoding = System.getProperty(Ghostscript.PROPERTY_NAME_ENCODING, System.getProperty("file.encoding"));
                    try {
                        byte[] buffer = new byte[1000];
                        int read = Ghostscript.this.getStdIn().read(buffer);
                        if (read != -1) {
                            buf.setString(0L, new String(buffer, 0, read, encoding));
                            buffer = null;
                            return read;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return 0;
                }
            };
        }
        GhostscriptLibrary.stdout_fn stdoutCallback = null;
        if (this.getStdOut() == null) {
            this.setStdOut(new GhostscriptLoggerOutputStream(Level.INFO));
        }
        stdoutCallback = new GhostscriptLibrary.stdout_fn(){

            public int callback(Pointer caller_handle, String str, int len) {
                try {
                    Ghostscript.this.getStdOut().write(str.getBytes(), 0, len);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return len;
            }
        };
        GhostscriptLibrary.stderr_fn stderrCallback = null;
        if (this.getStdErr() == null) {
            this.setStdErr(new GhostscriptLoggerOutputStream(Level.ERROR));
        }
        stderrCallback = new GhostscriptLibrary.stderr_fn(){

            public int callback(Pointer caller_handle, String str, int len) {
                try {
                    Ghostscript.this.getStdErr().write(str.getBytes(), 0, len);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return len;
            }
        };
        result = GhostscriptLibrary.instance.gsapi_set_stdio(this.getNativeInstanceByRef().getValue(), stdinCallback, stdoutCallback, stderrCallback);
        if (result != 0) {
            throw new GhostscriptException("Cannot set IO on Ghostscript interpreter. Error code is " + result);
        }
        if (this.getDisplayCallback() != null && (result = GhostscriptLibrary.instance.gsapi_set_display_callback(this.getNativeInstanceByRef().getValue(), this.buildNativeDisplayCallback(this.getDisplayCallback()))) != 0) {
            throw new GhostscriptException("Cannot set display callback on Ghostscript interpreter. Error code is " + result);
        }
        result = args != null ? GhostscriptLibrary.instance.gsapi_init_with_args(this.getNativeInstanceByRef().getValue(), args.length, args) : GhostscriptLibrary.instance.gsapi_init_with_args(this.getNativeInstanceByRef().getValue(), 0, null);
        if (result == -101) {
            this.exit();
            result = 0;
        }
        if (result != 0) {
            throw new GhostscriptException("Cannot initialize Ghostscript interpreter. Error code is " + result);
        }
    }

    private synchronized GhostscriptLibrary.display_callback_s buildNativeDisplayCallback(DisplayCallback displayCallback) throws GhostscriptException {
        nativeDisplayCallback = new GhostscriptLibrary.display_callback_s();
        float version = Float.parseFloat(Ghostscript.getRevision().getNumber());
        Ghostscript.nativeDisplayCallback.version_major = (double)version < 8.5 || version > 100.0f ? 1 : 2;
        Ghostscript.nativeDisplayCallback.version_minor = 0;
        Ghostscript.nativeDisplayCallback.display_open = new GhostscriptLibrary.display_callback_s.display_open(){

            public int callback(Pointer handle, Pointer device) {
                try {
                    Ghostscript.this.getDisplayCallback().displayOpen();
                }
                catch (GhostscriptException e) {
                    return 1;
                }
                return 0;
            }
        };
        Ghostscript.nativeDisplayCallback.display_preclose = new GhostscriptLibrary.display_callback_s.display_preclose(){

            public int callback(Pointer handle, Pointer device) {
                try {
                    Ghostscript.this.getDisplayCallback().displayPreClose();
                }
                catch (GhostscriptException e) {
                    return 1;
                }
                return 0;
            }
        };
        Ghostscript.nativeDisplayCallback.display_close = new GhostscriptLibrary.display_callback_s.display_close(){

            public int callback(Pointer handle, Pointer device) {
                try {
                    Ghostscript.this.getDisplayCallback().displayClose();
                }
                catch (GhostscriptException e) {
                    return 1;
                }
                return 0;
            }
        };
        Ghostscript.nativeDisplayCallback.display_presize = new GhostscriptLibrary.display_callback_s.display_presize(){

            public int callback(Pointer handle, Pointer device, int width, int height, int raster, int format) {
                try {
                    Ghostscript.this.getDisplayCallback().displayPreSize(width, height, raster, format);
                }
                catch (GhostscriptException e) {
                    return 1;
                }
                return 0;
            }
        };
        Ghostscript.nativeDisplayCallback.display_size = new GhostscriptLibrary.display_callback_s.display_size(){

            public int callback(Pointer handle, Pointer device, int width, int height, int raster, int format, Pointer pimage) {
                Ghostscript.this.getDisplayData().setWidth(width);
                Ghostscript.this.getDisplayData().setHeight(height);
                Ghostscript.this.getDisplayData().setRaster(raster);
                Ghostscript.this.getDisplayData().setFormat(format);
                Ghostscript.this.getDisplayData().setPimage(pimage);
                try {
                    Ghostscript.this.getDisplayCallback().displaySize(width, height, raster, format);
                }
                catch (GhostscriptException e) {
                    return 1;
                }
                return 0;
            }
        };
        Ghostscript.nativeDisplayCallback.display_sync = new GhostscriptLibrary.display_callback_s.display_sync(){

            public int callback(Pointer handle, Pointer device) {
                try {
                    Ghostscript.this.getDisplayCallback().displaySync();
                }
                catch (GhostscriptException e) {
                    return 1;
                }
                return 0;
            }
        };
        Ghostscript.nativeDisplayCallback.display_page = new GhostscriptLibrary.display_callback_s.display_page(){

            public int callback(Pointer handle, Pointer device, int copies, int flush) {
                byte[] data = Ghostscript.this.getDisplayData().getPimage().getByteArray(0L, Ghostscript.this.getDisplayData().getRaster() * Ghostscript.this.getDisplayData().getHeight());
                try {
                    Ghostscript.this.getDisplayCallback().displayPage(Ghostscript.this.getDisplayData().getWidth(), Ghostscript.this.getDisplayData().getHeight(), Ghostscript.this.getDisplayData().getRaster(), Ghostscript.this.getDisplayData().getFormat(), copies, flush, data);
                }
                catch (GhostscriptException e) {
                    return 1;
                }
                return 0;
            }
        };
        Ghostscript.nativeDisplayCallback.display_update = new GhostscriptLibrary.display_callback_s.display_update(){

            public int callback(Pointer handle, Pointer device, int x, int y, int w, int h) {
                try {
                    Ghostscript.this.getDisplayCallback().displayUpdate(x, y, w, h);
                }
                catch (GhostscriptException e) {
                    return 1;
                }
                return 0;
            }
        };
        Ghostscript.nativeDisplayCallback.display_memalloc = null;
        Ghostscript.nativeDisplayCallback.display_memfree = null;
        switch (Ghostscript.nativeDisplayCallback.version_major) {
            case 1: {
                Ghostscript.nativeDisplayCallback.size = nativeDisplayCallback.size() - Pointer.SIZE;
                break;
            }
            default: {
                Ghostscript.nativeDisplayCallback.size = nativeDisplayCallback.size();
            }
        }
        Ghostscript.nativeDisplayCallback.display_separation = null;
        return nativeDisplayCallback;
    }

    public void exit() throws GhostscriptException {
        int result;
        if (nativeInstanceByRef != null && (result = GhostscriptLibrary.instance.gsapi_exit(this.getNativeInstanceByRef().getValue())) != 0) {
            throw new GhostscriptException("Cannot exit Ghostscript interpreter. Error code is " + result);
        }
    }

    public void runString(String string) throws GhostscriptException {
        IntByReference exitCode = new IntByReference();
        GhostscriptLibrary.instance.gsapi_run_string_begin(this.getNativeInstanceByRef().getValue(), 0, exitCode);
        if (exitCode.getValue() != 0) {
            throw new GhostscriptException("Cannot run command on Ghostscript interpreter. gsapi_run_string_begin failed with error code " + exitCode.getValue());
        }
        String[] slices = string.split("\n");
        for (int i = 0; i < slices.length; ++i) {
            String slice = slices[i] + "\n";
            GhostscriptLibrary.instance.gsapi_run_string_continue(this.getNativeInstanceByRef().getValue(), slice, slice.length(), 0, exitCode);
            if (exitCode.getValue() == 0) continue;
            throw new GhostscriptException("Cannot run command on Ghostscript interpreter. gsapi_run_string_continue failed with error code " + exitCode.getValue());
        }
        GhostscriptLibrary.instance.gsapi_run_string_end(this.getNativeInstanceByRef().getValue(), 0, exitCode);
        if (exitCode.getValue() != 0) {
            throw new GhostscriptException("Cannot run command on Ghostscript interpreter. gsapi_run_string_end failed with error code " + exitCode.getValue());
        }
    }

    public void runFile(String fileName) throws GhostscriptException {
        IntByReference exitCode = new IntByReference();
        GhostscriptLibrary.instance.gsapi_run_file(this.getNativeInstanceByRef().getValue(), fileName, 0, exitCode);
        if (exitCode.getValue() != 0) {
            throw new GhostscriptException("Cannot run file on Ghostscript interpreter. Error code " + exitCode.getValue());
        }
    }

    public static synchronized void deleteInstance() throws GhostscriptException {
        if (instance != null) {
            instance = null;
        }
        if (nativeInstanceByRef != null) {
            GhostscriptLibrary.instance.gsapi_delete_instance(nativeInstanceByRef.getValue());
            nativeInstanceByRef = null;
        }
    }
}

