/*
 * Decompiled with CFR 0.152.
 */
package org.ghost4j.document;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PaperSize
implements Serializable {
    private static final long serialVersionUID = -1614204334526018509L;
    private static final Map<String, PaperSize> index = new HashMap<String, PaperSize>();
    public static final PaperSize LEDGER = new PaperSize("ledger", 1224, 792);
    public static final PaperSize LEGAL = new PaperSize("legal", 612, 1008);
    public static final PaperSize LETTER = new PaperSize("letter", 612, 792);
    public static final PaperSize ARCHE = new PaperSize("archE", 2592, 3456);
    public static final PaperSize ARCHD = new PaperSize("archD", 1728, 2592);
    public static final PaperSize ARCHC = new PaperSize("archC", 1296, 1728);
    public static final PaperSize ARCHB = new PaperSize("archB", 864, 1296);
    public static final PaperSize ARCHA = new PaperSize("archA", 648, 864);
    public static final PaperSize A0 = new PaperSize("a0", 2384, 3370);
    public static final PaperSize A1 = new PaperSize("a1", 1684, 2384);
    public static final PaperSize A2 = new PaperSize("a2", 1191, 1684);
    public static final PaperSize A3 = new PaperSize("a3", 842, 1191);
    public static final PaperSize A4 = new PaperSize("a4", 595, 842);
    public static final PaperSize A5 = new PaperSize("a5", 420, 595);
    public static final PaperSize A6 = new PaperSize("a6", 297, 420);
    public static final PaperSize A7 = new PaperSize("a7", 210, 297);
    public static final PaperSize A8 = new PaperSize("a8", 148, 210);
    public static final PaperSize A9 = new PaperSize("a9", 105, 148);
    public static final PaperSize A10 = new PaperSize("a10", 73, 105);
    private final int width;
    private final int height;
    private String name;

    public PaperSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaperSize(String name, int width, int height) {
        this.width = width;
        this.height = height;
        this.name = name;
        if (this.name != null) {
            Map<String, PaperSize> map = index;
            synchronized (map) {
                index.put(this.name.toLowerCase(), this);
            }
        }
    }

    public PaperSize scale(float factor) {
        return new PaperSize((int)((float)this.width * factor), (int)((float)this.height * factor));
    }

    public PaperSize portrait() {
        if (this.width > this.height) {
            return new PaperSize(this.height, this.width);
        }
        return new PaperSize(this.width, this.height);
    }

    public PaperSize landscape() {
        if (this.width < this.height) {
            return new PaperSize(this.height, this.width);
        }
        return new PaperSize(this.width, this.height);
    }

    public static synchronized PaperSize getStandardPaperSize(String name) {
        return index.get(name.toLowerCase());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }
}

