/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jeasy.batch.core.converter.TypeConverter;
import org.jeasy.batch.core.util.Utils;

public class DateTypeConverter
implements TypeConverter<String, Date> {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private String dateFormat;

    public DateTypeConverter() {
        this(DEFAULT_DATE_FORMAT);
    }

    public DateTypeConverter(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public Date convert(String value) {
        Utils.checkArgument(value != null, "Value to convert must not be null");
        Utils.checkArgument(!value.isEmpty(), "Value to convert must not be empty");
        try {
            return new SimpleDateFormat(this.dateFormat).parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to convert value '" + value + "' to a Date object with format " + this.dateFormat, e);
        }
    }
}

