/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.filter;

import java.util.ArrayList;
import java.util.List;
import org.jeasy.batch.core.filter.RecordFilter;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;

public class FilteredRecordsCollector<P>
implements RecordFilter<P> {
    private List<Record<P>> filteredRecords = new ArrayList<Record<P>>();
    private RecordFilter<P> delegate;

    public FilteredRecordsCollector(RecordFilter<P> delegate) {
        Utils.checkNotNull(delegate, "delegate record filter");
        this.delegate = delegate;
    }

    @Override
    public Record<P> processRecord(Record<P> record) {
        Record<P> filteredRecord = this.delegate.processRecord(record);
        if (null == filteredRecord) {
            this.filteredRecords.add(record);
        }
        return filteredRecord;
    }

    public List<Record<P>> getFilteredRecords() {
        return this.filteredRecords;
    }
}

