/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.job;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.jeasy.batch.core.job.JobMetrics;
import org.jeasy.batch.core.job.JobParameters;
import org.jeasy.batch.core.job.JobStatus;
import org.jeasy.batch.core.util.Utils;

public class JobReport
implements Serializable {
    private static final String REPORT_FORMAT = "Job Report:" + Utils.LINE_SEPARATOR + "===========" + Utils.LINE_SEPARATOR + "Name: {0}" + Utils.LINE_SEPARATOR + "Status: {1}" + Utils.LINE_SEPARATOR + "Parameters:" + Utils.LINE_SEPARATOR + "\tBatch size = {2}" + Utils.LINE_SEPARATOR + "\tError threshold = {3}" + Utils.LINE_SEPARATOR + "\tJmx monitoring = {4}" + Utils.LINE_SEPARATOR + "\tBatch scanning = {5}" + Utils.LINE_SEPARATOR + "Metrics:" + Utils.LINE_SEPARATOR + "\tStart time = {6}" + Utils.LINE_SEPARATOR + "\tEnd time = {7}" + Utils.LINE_SEPARATOR + "\tDuration = {8}" + Utils.LINE_SEPARATOR + "\tRead count = {9}" + Utils.LINE_SEPARATOR + "\tWrite count = {10}" + Utils.LINE_SEPARATOR + "\tFilter count = {11}" + Utils.LINE_SEPARATOR + "\tError count = {12}";
    private String jobName;
    private JobParameters parameters;
    private JobMetrics metrics;
    private JobStatus status;
    private Throwable lastError;
    private Properties systemProperties;

    public String getJobName() {
        return this.jobName;
    }

    public JobParameters getParameters() {
        return this.parameters;
    }

    public JobMetrics getMetrics() {
        return this.metrics;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setParameters(JobParameters parameters) {
        this.parameters = parameters;
    }

    public void setMetrics(JobMetrics metrics) {
        this.metrics = metrics;
    }

    public void setStatus(JobStatus status) {
        this.status = status;
    }

    public void setLastError(Throwable lastError) {
        this.lastError = lastError;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public String toString() {
        String baseReport = MessageFormat.format(REPORT_FORMAT, new Object[]{this.jobName, this.status, this.parameters.getBatchSize(), Utils.formatErrorThreshold(this.parameters.getErrorThreshold()), this.parameters.isJmxMonitoring(), this.parameters.isBatchScanningEnabled(), Utils.formatTime(this.metrics.getStartTime()), Utils.formatTime(this.metrics.getEndTime()), Utils.formatDuration(this.metrics.getDuration()), this.metrics.getReadCount(), this.metrics.getWriteCount(), this.metrics.getFilterCount(), this.metrics.getErrorCount()});
        StringBuilder sb = new StringBuilder(baseReport);
        for (Map.Entry<String, Object> customMetric : this.metrics.getCustomMetrics().entrySet()) {
            sb.append(Utils.LINE_SEPARATOR).append("\t").append(customMetric.getKey()).append(" = ").append(customMetric.getValue());
        }
        return sb.toString();
    }
}

