/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.core.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jeasy.batch.core.listener.RecordWriterListener;
import org.jeasy.batch.core.record.Batch;

public class CompositeRecordWriterListener<P>
implements RecordWriterListener<P> {
    private List<RecordWriterListener<P>> listeners;

    public CompositeRecordWriterListener() {
        this(new ArrayList<RecordWriterListener<P>>());
    }

    public CompositeRecordWriterListener(List<RecordWriterListener<P>> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeRecordWriting(Batch<P> batch) {
        for (RecordWriterListener<P> listener : this.listeners) {
            listener.beforeRecordWriting(batch);
        }
    }

    @Override
    public void afterRecordWriting(Batch<P> batch) {
        ListIterator<RecordWriterListener<P>> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().afterRecordWriting(batch);
        }
    }

    @Override
    public void onRecordWritingException(Batch<P> batch, Throwable throwable) {
        ListIterator<RecordWriterListener<P>> iterator = this.listeners.listIterator(this.listeners.size());
        while (iterator.hasPrevious()) {
            iterator.previous().onRecordWritingException(batch, throwable);
        }
    }

    public void addRecordWriterListener(RecordWriterListener<P> recordWriterListener) {
        this.listeners.add(recordWriterListener);
    }
}

