/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.jpa;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.core.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaRecordReader<T>
implements RecordReader<T> {
    public static final int DEFAULT_MAX_RESULT = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JpaRecordReader.class.getSimpleName());
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private String query;
    private TypedQuery<T> typedQuery;
    private Class<T> type;
    private List<T> records;
    private Iterator<T> iterator;
    private int offset;
    private int maxResults;
    private long currentRecordNumber;

    public JpaRecordReader(EntityManagerFactory entityManagerFactory, String query, Class<T> type) {
        Utils.checkNotNull((Object)entityManagerFactory, (String)"entity manager factory");
        Utils.checkNotNull((Object)query, (String)"query");
        Utils.checkNotNull(type, (String)"target type");
        this.entityManagerFactory = entityManagerFactory;
        this.query = query;
        this.type = type;
        this.maxResults = 1000;
    }

    public void open() {
        this.currentRecordNumber = 0L;
        this.offset = 0;
        LOGGER.debug("Creating a JPA entity manager");
        this.entityManager = this.entityManagerFactory.createEntityManager();
        this.typedQuery = this.entityManager.createQuery(this.query, this.type);
        this.typedQuery.setFirstResult(this.offset);
        this.typedQuery.setMaxResults(this.maxResults);
        this.records = this.typedQuery.getResultList();
        this.iterator = this.records.iterator();
    }

    private boolean hasNextRecord() {
        if (!this.iterator.hasNext()) {
            this.typedQuery.setFirstResult(this.offset += this.records.size());
            this.records = this.typedQuery.getResultList();
            this.iterator = this.records.iterator();
        }
        return this.iterator.hasNext();
    }

    public GenericRecord<T> readRecord() {
        Header header = new Header(Long.valueOf(++this.currentRecordNumber), this.getDataSourceName(), LocalDateTime.now());
        if (this.hasNextRecord()) {
            return new GenericRecord(header, this.iterator.next());
        }
        return null;
    }

    private String getDataSourceName() {
        return "Result of JPA query: " + this.query;
    }

    public void close() {
        LOGGER.debug("Closing JPA entity manager");
        this.entityManager.close();
    }

    public void setMaxResults(int maxResults) {
        Utils.checkArgument((maxResults >= 1 ? 1 : 0) != 0, (String)"max results parameter must be >= 1");
        this.maxResults = maxResults;
    }
}

