/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.core.writer.RecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaRecordWriter<P>
implements RecordWriter<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JpaRecordWriter.class.getSimpleName());
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;

    public JpaRecordWriter(EntityManagerFactory entityManagerFactory) {
        Utils.checkNotNull((Object)entityManagerFactory, (String)"entity manager factory");
        this.entityManagerFactory = entityManagerFactory;
    }

    public void open() {
        LOGGER.debug("Creating a JPA entity manager");
        this.entityManager = this.entityManagerFactory.createEntityManager();
    }

    public void writeRecords(Batch<P> batch) {
        EntityTransaction transaction = this.entityManager.getTransaction();
        transaction.begin();
        try {
            for (Record record : batch) {
                this.entityManager.persist(record.getPayload());
            }
            this.entityManager.flush();
            this.entityManager.clear();
            transaction.commit();
            LOGGER.debug("Transaction committed");
        }
        catch (Exception e) {
            LOGGER.error("Unable to commit transaction", (Throwable)e);
            transaction.rollback();
            throw e;
        }
    }

    public void close() {
        if (this.entityManager != null) {
            LOGGER.debug("Closing JPA entity manager");
            this.entityManager.close();
        }
    }
}

