/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.boot.autoconfigure;

import java.io.InputStream;
import java.util.HashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.boot.autoconfigure.JodConverterLocalProperties;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DefaultDocumentFormatRegistryInstanceHolder;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.document.JsonDocumentFormatRegistry;
import org.jodconverter.core.document.SimpleDocumentFormatRegistry;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.util.StringUtils;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.LocalOfficeManager;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.process.ProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@AutoConfiguration
@ConditionalOnClass(value={LocalConverter.class})
@ConditionalOnProperty(prefix="jodconverter.local", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={JodConverterLocalProperties.class})
public class JodConverterLocalAutoConfiguration {
    private static final String DEFAULT_FORMATS_PATH = "classpath:document-formats.json";
    private static final String CUSTOM_FORMATS_PATH = "classpath:custom-document-formats.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(JodConverterLocalAutoConfiguration.class);
    private final JodConverterLocalProperties properties;

    public JodConverterLocalAutoConfiguration(@NonNull JodConverterLocalProperties properties) {
        this.properties = properties;
    }

    private OfficeManager createOfficeManager(ProcessManager processManager) {
        LocalOfficeManager.Builder builder = ((LocalOfficeManager.Builder)((LocalOfficeManager.Builder)((LocalOfficeManager.Builder)LocalOfficeManager.builder().officeHome(this.properties.getOfficeHome()).hostName(this.properties.getHostName()).portNumbers(this.properties.getPortNumbers()).pipeNames(this.properties.getPipeNames()).workingDir(this.properties.getWorkingDir())).templateProfileDir(this.properties.getTemplateProfileDir()).existingProcessAction(this.properties.getExistingProcessAction()).processTimeout(Long.valueOf(this.properties.getProcessTimeout())).processRetryInterval(Long.valueOf(this.properties.getProcessRetryInterval())).afterStartProcessDelay(Long.valueOf(this.properties.getAfterStartProcessDelay())).startFailFast(Boolean.valueOf(this.properties.isStartFailFast())).keepAliveOnShutdown(Boolean.valueOf(this.properties.isKeepAliveOnShutdown())).taskQueueTimeout(Long.valueOf(this.properties.getTaskQueueTimeout()))).taskExecutionTimeout(Long.valueOf(this.properties.getTaskExecutionTimeout()))).maxTasksPerProcess(Integer.valueOf(this.properties.getMaxTasksPerProcess()));
        if (StringUtils.isBlank((String)this.properties.getProcessManagerClass())) {
            builder.processManager(processManager);
        } else {
            builder.processManager(this.properties.getProcessManagerClass());
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"processManager"})
    ProcessManager processManager() {
        return LocalOfficeUtils.findBestProcessManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"documentFormatRegistry"})
    DocumentFormatRegistry documentFormatRegistry(ResourceLoader resourceLoader) throws Exception {
        String registryResourceName = StringUtils.isBlank((String)this.properties.getDocumentFormatRegistry()) ? DEFAULT_FORMATS_PATH : this.properties.getDocumentFormatRegistry();
        LOGGER.debug("Loading document formats registry from resource [{}]", (Object)registryResourceName);
        try (InputStream in = resourceLoader.getResource(registryResourceName).getInputStream();){
            JsonDocumentFormatRegistry registry = this.properties.getFormatOptions() == null ? JsonDocumentFormatRegistry.create((InputStream)in) : JsonDocumentFormatRegistry.create((InputStream)in, this.properties.getFormatOptions());
            Resource resource = resourceLoader.getResource(CUSTOM_FORMATS_PATH);
            if (resource.exists()) {
                LOGGER.debug("Loading custom document formats registry from resource [{}]", (Object)CUSTOM_FORMATS_PATH);
                registry.addRegistry((SimpleDocumentFormatRegistry)JsonDocumentFormatRegistry.create((InputStream)resource.getInputStream()));
            }
            DefaultDocumentFormatRegistryInstanceHolder.setInstance((DocumentFormatRegistry)registry);
            JsonDocumentFormatRegistry jsonDocumentFormatRegistry = registry;
            return jsonDocumentFormatRegistry;
        }
    }

    @Bean(name={"localOfficeManager"}, initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"localOfficeManager"})
    OfficeManager localOfficeManager(ProcessManager processManager) {
        return this.createOfficeManager(processManager);
    }

    @Bean
    @ConditionalOnMissingBean(name={"localDocumentConverter"})
    @ConditionalOnBean(name={"localOfficeManager", "documentFormatRegistry"})
    DocumentConverter localDocumentConverter(OfficeManager localOfficeManager, DocumentFormatRegistry documentFormatRegistry) {
        HashMap<String, Short> loadProperties = new HashMap<String, Short>();
        if (this.properties.isApplyDefaultLoadProperties()) {
            loadProperties.putAll(LocalConverter.DEFAULT_LOAD_PROPERTIES);
            if (this.properties.isUseUnsafeQuietUpdate()) {
                loadProperties.put("UpdateDocMode", (short)1);
            }
        }
        return ((LocalConverter.Builder)((LocalConverter.Builder)LocalConverter.builder().officeManager(localOfficeManager)).formatRegistry(documentFormatRegistry)).loadDocumentMode(this.properties.getLoadDocumentMode()).loadProperties(loadProperties).build();
    }
}

