/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.crypt;

import java.security.MessageDigest;
import jodd.util.StringUtil;

public interface DigestEngine {
    public static DigestEngine md2() {
        return new JavaDigestEngine("MD2");
    }

    public static DigestEngine md5() {
        return new JavaDigestEngine("MD5");
    }

    public static DigestEngine sha1() {
        return new JavaDigestEngine("SHA-1");
    }

    public static DigestEngine sha256() {
        return new JavaDigestEngine("SHA-256");
    }

    public static DigestEngine sha384() {
        return new JavaDigestEngine("SHA-384");
    }

    public static DigestEngine sha512() {
        return new JavaDigestEngine("SHA-512");
    }

    public byte[] digest(byte[] var1);

    default public byte[] digest(String input) {
        return this.digest(StringUtil.getBytes(input));
    }

    default public String digestString(byte[] byteArray) {
        return StringUtil.toHexString(this.digest(byteArray));
    }

    default public String digestString(String input) {
        return StringUtil.toHexString(this.digest(input));
    }

    public static class JavaDigestEngine
    implements DigestEngine {
        private MessageDigest messageDigest;

        JavaDigestEngine(String algorithm) {
            try {
                this.messageDigest = MessageDigest.getInstance(algorithm);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] digest(byte[] byteArray) {
            this.messageDigest.update(byteArray);
            return this.messageDigest.digest();
        }
    }
}

