/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml.dynamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ibatis.builder.xml.dynamic.DynamicContext;
import org.apache.ibatis.builder.xml.dynamic.SqlNode;
import org.apache.ibatis.session.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimSqlNode
implements SqlNode {
    private SqlNode contents;
    private String prefix;
    private String suffix;
    private List<String> prefixesToOverride = new ArrayList<String>();
    private List<String> suffixesToOverride = new ArrayList<String>();
    private Configuration configuration;

    public TrimSqlNode(Configuration configuration, SqlNode contents, String prefix, String prefixesToOverride, String suffix, String suffixesToOverride) {
        this.contents = contents;
        this.prefix = prefix;
        this.prefixesToOverride = this.parseOverrides(prefixesToOverride);
        this.suffix = suffix;
        this.suffixesToOverride = this.parseOverrides(suffixesToOverride);
        this.configuration = configuration;
    }

    @Override
    public boolean apply(DynamicContext context) {
        FilteredDynamicContext filteredDynamicContext = new FilteredDynamicContext(context);
        boolean result = this.contents.apply(filteredDynamicContext);
        filteredDynamicContext.applyAll();
        return result;
    }

    private List<String> parseOverrides(String overrides) {
        if (overrides != null) {
            final StringTokenizer parser = new StringTokenizer(overrides, "|", false);
            return new ArrayList<String>(){
                private static final long serialVersionUID = -2504816393625384165L;
                {
                    while (parser.hasMoreTokens()) {
                        this.add(parser.nextToken().toUpperCase(Locale.ENGLISH));
                    }
                }
            };
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteredDynamicContext
    extends DynamicContext {
        private DynamicContext delegate;
        private boolean prefixApplied;
        private boolean suffixApplied;
        private StringBuilder sqlBuffer;

        public FilteredDynamicContext(DynamicContext delegate) {
            super(TrimSqlNode.this.configuration, null);
            this.delegate = delegate;
            this.prefixApplied = false;
            this.suffixApplied = false;
            this.sqlBuffer = new StringBuilder();
        }

        public void applyAll() {
            this.sqlBuffer = new StringBuilder(this.sqlBuffer.toString().trim());
            String trimmedUppercaseSql = this.sqlBuffer.toString().toUpperCase(Locale.ENGLISH);
            if (trimmedUppercaseSql.length() > 0) {
                this.applyPrefix(this.sqlBuffer, trimmedUppercaseSql);
                this.applySuffix(this.sqlBuffer, trimmedUppercaseSql);
            }
            this.delegate.appendSql(this.sqlBuffer.toString());
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.delegate.getBindings();
        }

        @Override
        public void bind(String name, Object value) {
            this.delegate.bind(name, value);
        }

        @Override
        public int getUniqueNumber() {
            return this.delegate.getUniqueNumber();
        }

        @Override
        public void appendSql(String sql) {
            this.sqlBuffer.append(sql);
        }

        @Override
        public String getSql() {
            return this.delegate.getSql();
        }

        private void applyPrefix(StringBuilder sql, String trimmedUppercaseSql) {
            if (!this.prefixApplied) {
                this.prefixApplied = true;
                for (String toRemove : TrimSqlNode.this.prefixesToOverride) {
                    if (!trimmedUppercaseSql.startsWith(toRemove) && !trimmedUppercaseSql.startsWith(toRemove.trim())) continue;
                    sql.delete(0, toRemove.trim().length());
                    break;
                }
                if (TrimSqlNode.this.prefix != null) {
                    sql.insert(0, " ");
                    sql.insert(0, TrimSqlNode.this.prefix);
                }
            }
        }

        private void applySuffix(StringBuilder sql, String trimmedUppercaseSql) {
            if (!this.suffixApplied) {
                this.suffixApplied = true;
                for (String toRemove : TrimSqlNode.this.suffixesToOverride) {
                    if (!trimmedUppercaseSql.endsWith(toRemove) && !trimmedUppercaseSql.endsWith(toRemove.trim())) continue;
                    int start = sql.length() - toRemove.trim().length();
                    int end = sql.length();
                    sql.delete(start, end);
                    break;
                }
                if (TrimSqlNode.this.suffix != null) {
                    sql.append(" ");
                    sql.append(TrimSqlNode.this.suffix);
                }
            }
        }
    }
}

