/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.session.defaults;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.logging.jdbc.ConnectionLogger;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionException;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;

public class DefaultSqlSessionFactory
implements SqlSessionFactory {
    private static final Log log = LogFactory.getLog(Connection.class);
    private final Configuration configuration;
    private final TransactionFactory managedTransactionFactory;

    public DefaultSqlSessionFactory(Configuration configuration) {
        this.configuration = configuration;
        this.managedTransactionFactory = new ManagedTransactionFactory();
    }

    public SqlSession openSession() {
        return this.openSessionFromDataSource(this.configuration.getDefaultExecutorType(), null, false);
    }

    public SqlSession openSession(boolean autoCommit) {
        return this.openSessionFromDataSource(this.configuration.getDefaultExecutorType(), null, autoCommit);
    }

    public SqlSession openSession(ExecutorType execType) {
        return this.openSessionFromDataSource(execType, null, false);
    }

    public SqlSession openSession(TransactionIsolationLevel level) {
        return this.openSessionFromDataSource(this.configuration.getDefaultExecutorType(), level, false);
    }

    public SqlSession openSession(ExecutorType execType, TransactionIsolationLevel level) {
        return this.openSessionFromDataSource(execType, level, false);
    }

    public SqlSession openSession(ExecutorType execType, boolean autoCommit) {
        return this.openSessionFromDataSource(execType, null, autoCommit);
    }

    public SqlSession openSession(Connection connection) {
        return this.openSessionFromConnection(this.configuration.getDefaultExecutorType(), connection);
    }

    public SqlSession openSession(ExecutorType execType, Connection connection) {
        return this.openSessionFromConnection(execType, connection);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private SqlSession openSessionFromDataSource(ExecutorType execType, TransactionIsolationLevel level, boolean autoCommit) {
        DefaultSqlSession defaultSqlSession;
        Connection connection = null;
        try {
            Environment environment = this.configuration.getEnvironment();
            DataSource dataSource = this.getDataSourceFromEnvironment(environment);
            TransactionFactory transactionFactory = this.getTransactionFactoryFromEnvironment(environment);
            connection = dataSource.getConnection();
            if (level != null) {
                connection.setTransactionIsolation(level.getLevel());
            }
            connection = this.wrapConnection(connection);
            Transaction tx = transactionFactory.newTransaction(connection, autoCommit);
            Executor executor = this.configuration.newExecutor(tx, execType);
            defaultSqlSession = new DefaultSqlSession(this.configuration, executor, autoCommit);
            Object var12_12 = null;
            ErrorContext.instance().reset();
        }
        catch (Exception e) {
            try {
                this.closeConnection(connection);
                throw ExceptionFactory.wrapException("Error opening session.  Cause: " + e, e);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                ErrorContext.instance().reset();
                throw throwable;
            }
        }
        return defaultSqlSession;
    }

    private SqlSession openSessionFromConnection(ExecutorType execType, Connection connection) {
        DefaultSqlSession defaultSqlSession;
        try {
            boolean autoCommit;
            try {
                autoCommit = connection.getAutoCommit();
            }
            catch (SQLException e) {
                autoCommit = true;
            }
            connection = this.wrapConnection(connection);
            Environment environment = this.configuration.getEnvironment();
            TransactionFactory transactionFactory = this.getTransactionFactoryFromEnvironment(environment);
            Transaction tx = transactionFactory.newTransaction(connection, autoCommit);
            Executor executor = this.configuration.newExecutor(tx, execType);
            defaultSqlSession = new DefaultSqlSession(this.configuration, executor, autoCommit);
            Object var10_11 = null;
            ErrorContext.instance().reset();
        }
        catch (Exception e) {
            try {
                throw ExceptionFactory.wrapException("Error opening session.  Cause: " + e, e);
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                ErrorContext.instance().reset();
                throw throwable;
            }
        }
        return defaultSqlSession;
    }

    private DataSource getDataSourceFromEnvironment(Environment environment) {
        if (environment == null || environment.getDataSource() == null) {
            throw new SqlSessionException("Configuration does not include an environment with a DataSource, so session cannot be created unless a connection is passed in.");
        }
        return environment.getDataSource();
    }

    private TransactionFactory getTransactionFactoryFromEnvironment(Environment environment) {
        if (environment == null || environment.getTransactionFactory() == null) {
            return this.managedTransactionFactory;
        }
        return environment.getTransactionFactory();
    }

    private Connection wrapConnection(Connection connection) {
        if (log.isDebugEnabled()) {
            return ConnectionLogger.newInstance(connection);
        }
        return connection;
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

