/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.HtmlMaker;
import org.ofdrw.converter.ItextMaker;
import org.ofdrw.converter.PdfboxMaker;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertHelper {
    private static final Logger logger = LoggerFactory.getLogger(ConvertHelper.class);
    public static Lib lib = Lib.iText;

    public static void useIText() {
        lib = Lib.iText;
    }

    public static void usePDFBox() {
        lib = Lib.PDFBox;
    }

    /*
     * Unable to fully structure code
     */
    public static void ofd2pdf(Object input, Object output) {
        block63: {
            reader = null;
            try {
                if (input instanceof InputStream) {
                    reader = new OFDReader((InputStream)input);
                } else if (input instanceof Path) {
                    reader = new OFDReader((Path)input);
                } else if (input instanceof File) {
                    reader = new OFDReader((InputStream)new FileInputStream((File)input));
                } else if (input instanceof String) {
                    reader = new OFDReader((String)input);
                } else {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8f93\u5165\u683c\u5f0f(input)\uff0c\u4ec5\u652f\u6301InputStream\u3001Path\u3001File\u3001String");
                }
                bos = new ByteArrayOutputStream();
                switch (1.$SwitchMap$org$ofdrw$converter$ConvertHelper$Lib[ConvertHelper.lib.ordinal()]) {
                    case 1: {
                        pdfWriter = new PdfWriter((OutputStream)bos);
                        var5_8 = null;
                        pdfDocument = new PdfDocument(pdfWriter);
                        var7_16 = null;
                        try {
                            pageNum = 1;
                            pdfMaker = new ItextMaker(reader);
                            for (PageInfo pageInfo : reader.getPageList()) {
                                start = System.currentTimeMillis();
                                pdfMaker.makePage(pdfDocument, pageInfo);
                                end = System.currentTimeMillis();
                                ConvertHelper.logger.info(String.format("page %d speed time %d", new Object[]{pageNum++, end - start}));
                            }
                        }
                        catch (Throwable var8_25) {
                            var7_16 = var8_25;
                            throw var8_25;
                        }
                        finally {
                            if (pdfDocument != null) {
                                if (var7_16 != null) {
                                    try {
                                        pdfDocument.close();
                                    }
                                    catch (Throwable var8_24) {
                                        var7_16.addSuppressed(var8_24);
                                    }
                                } else {
                                    pdfDocument.close();
                                }
                            }
                        }
                        if (pdfWriter == null) break;
                        if (var5_8 == null) ** GOTO lbl57
                        try {
                            pdfWriter.close();
                        }
                        catch (Throwable pdfDocument) {
                            var5_8.addSuppressed(pdfDocument);
                        }
                        break;
lbl57:
                        // 1 sources

                        pdfWriter.close();
                        break;
                        catch (Throwable pdfDocument) {
                            try {
                                var5_8 = pdfDocument;
                                throw pdfDocument;
                            }
                            catch (Throwable var18_30) {
                                if (pdfWriter != null) {
                                    if (var5_8 != null) {
                                        try {
                                            pdfWriter.close();
                                        }
                                        catch (Throwable var19_31) {
                                            var5_8.addSuppressed(var19_31);
                                        }
                                    } else {
                                        pdfWriter.close();
                                    }
                                }
                                throw var18_30;
                            }
                        }
                    }
                    case 2: {
                        pdfDocument = new PDDocument();
                        var5_9 = null;
                        pdfMaker = new PdfboxMaker(reader, pdfDocument);
                        start = 0L;
                        end = 0L;
                        pageNum = 1L;
                        for (PageInfo pageInfo : reader.getPageList()) {
                            start = System.currentTimeMillis();
                            pdfMaker.makePage(pageInfo);
                            end = System.currentTimeMillis();
                            ConvertHelper.logger.debug(String.format("page %d speed time %d", new Object[]{pageNum++, end - start}));
                        }
                        pdfDocument.save((OutputStream)bos);
                        if (pdfDocument == null) break;
                        if (var5_9 == null) ** GOTO lbl98
                        try {
                            pdfDocument.close();
                        }
                        catch (Throwable var6_14) {
                            var5_9.addSuppressed(var6_14);
                        }
                        break;
lbl98:
                        // 1 sources

                        pdfDocument.close();
                        break;
                        catch (Throwable var6_15) {
                            try {
                                var5_9 = var6_15;
                                throw var6_15;
                            }
                            catch (Throwable var20_34) {
                                if (pdfDocument != null) {
                                    if (var5_9 != null) {
                                        try {
                                            pdfDocument.close();
                                        }
                                        catch (Throwable var21_35) {
                                            var5_9.addSuppressed(var21_35);
                                        }
                                    } else {
                                        pdfDocument.close();
                                    }
                                }
                                throw var20_34;
                            }
                        }
                    }
                }
                if (output instanceof OutputStream) {
                    bos.writeTo((OutputStream)output);
                    break block63;
                }
                if (output instanceof File) {
                    fileOutputStream = new FileOutputStream((File)output);
                    bos.writeTo(fileOutputStream);
                    break block63;
                }
                if (output instanceof String) {
                    fileOutputStream = new FileOutputStream(new File((String)output));
                    bos.writeTo(fileOutputStream);
                    break block63;
                }
                if (output instanceof Path) {
                    bos.writeTo(Files.newOutputStream((Path)output, new OpenOption[0]));
                    break block63;
                }
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8f93\u51fa\u683c\u5f0f(output)\uff0c\u4ec5\u652f\u6301OutputStream\u3001Path\u3001File\u3001String");
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                ConvertHelper.logger.error("convert to pdf failed", (Throwable)e);
                throw new GeneralConvertException(e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    ConvertHelper.logger.error("close OFDReader failed", (Throwable)e);
                }
            }
        }
    }

    public static void toPdf(InputStream input, OutputStream output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(InputStream input, File output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(InputStream input, String output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(Path input, OutputStream output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(Path input, File output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(Path input, Path output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(String unzippedPathRoot, String output, boolean deleteOnClose) {
        OFDReader reader = null;
        PDDocument pdfDocument = null;
        try {
            reader = new OFDReader(unzippedPathRoot, deleteOnClose);
            pdfDocument = new PDDocument();
            PdfboxMaker pdfMaker = new PdfboxMaker(reader, pdfDocument);
            List ofdPageVoList = reader.getPageList();
            long start = 0L;
            long end = 0L;
            long pageNum = 1L;
            for (PageInfo pageInfo : ofdPageVoList) {
                start = System.currentTimeMillis();
                pdfMaker.makePage(pageInfo);
                end = System.currentTimeMillis();
                logger.debug(String.format("page %d speed time %d", pageNum++, end - start));
            }
            pdfDocument.save(output);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("convert to pdf failed", (Throwable)e);
            throw new GeneralConvertException(e);
        }
        finally {
            try {
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.error("close OFDReader failed", (Throwable)e);
            }
        }
    }

    public static void toHtml(OFDReader ofdReader, String output, int screenWidth) throws IOException {
        HtmlMaker htmlMaker = new HtmlMaker(ofdReader, output, screenWidth);
        htmlMaker.parse();
    }

    public static void toHtml(Path ofdIn, Path htmlOut, int screenWidth) throws IOException {
        try (OFDReader reader = new OFDReader(ofdIn);){
            HtmlMaker htmlMaker = new HtmlMaker(reader, htmlOut.toAbsolutePath().toString(), screenWidth);
            htmlMaker.parse();
        }
    }

    public static enum Lib {
        iText,
        PDFBox;

    }
}

