/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.metrics.BatchMetrics;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.util.Assert;

public class SimpleJobLauncher
implements JobLauncher,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(SimpleJobLauncher.class);
    private JobRepository jobRepository;
    private TaskExecutor taskExecutor;

    @Override
    public JobExecution run(final Job job, final JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        Assert.notNull((Object)job, (String)"The Job must not be null.");
        Assert.notNull((Object)jobParameters, (String)"The JobParameters must not be null.");
        JobExecution lastExecution = this.jobRepository.getLastJobExecution(job.getName(), jobParameters);
        if (lastExecution != null) {
            if (!job.isRestartable()) {
                throw new JobRestartException("JobInstance already exists and is not restartable");
            }
            for (StepExecution execution : lastExecution.getStepExecutions()) {
                BatchStatus status = execution.getStatus();
                if (status.isRunning() || status == BatchStatus.STOPPING) {
                    throw new JobExecutionAlreadyRunningException("A job execution for this job is already running: " + lastExecution);
                }
                if (status != BatchStatus.UNKNOWN) continue;
                throw new JobRestartException("Cannot restart step [" + execution.getStepName() + "] from UNKNOWN status. The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed. Manual intervention is probably necessary.");
            }
        }
        job.getJobParametersValidator().validate(jobParameters);
        final JobExecution jobExecution = this.jobRepository.createJobExecution(job.getName(), jobParameters);
        try {
            this.taskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Job: [" + job + "] launched with the following parameters: [" + jobParameters + "]"));
                        }
                        job.execute(jobExecution);
                        if (logger.isInfoEnabled()) {
                            Duration jobExecutionDuration = BatchMetrics.calculateDuration(jobExecution.getStartTime(), jobExecution.getEndTime());
                            logger.info((Object)("Job: [" + job + "] completed with the following parameters: [" + jobParameters + "] and the following status: [" + (Object)((Object)jobExecution.getStatus()) + "]" + (jobExecutionDuration == null ? "" : " in " + BatchMetrics.formatDuration(jobExecutionDuration))));
                        }
                    }
                    catch (Throwable t) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Job: [" + job + "] failed unexpectedly and fatally with the following parameters: [" + jobParameters + "]"), t);
                        }
                        this.rethrow(t);
                    }
                }

                private void rethrow(Throwable t) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new IllegalStateException(t);
                }
            });
        }
        catch (TaskRejectedException e) {
            jobExecution.upgradeStatus(BatchStatus.FAILED);
            if (jobExecution.getExitStatus().equals(ExitStatus.UNKNOWN)) {
                jobExecution.setExitStatus(ExitStatus.FAILED.addExitDescription(e));
            }
            this.jobRepository.update(jobExecution);
        }
        return jobExecution;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jobRepository != null ? 1 : 0) != 0, (String)"A JobRepository has not been set.");
        if (this.taskExecutor == null) {
            logger.info((Object)"No TaskExecutor has been set, defaulting to synchronous executor.");
            this.taskExecutor = new SyncTaskExecutor();
        }
    }
}

