/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.sql.DataSource;
import org.springframework.batch.core.DefaultJobKeyGenerator;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.configuration.BatchConfigurationException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.JobRegistryBeanPostProcessor;
import org.springframework.batch.core.configuration.support.MapJobRegistry;
import org.springframework.batch.core.configuration.support.ScopeConfiguration;
import org.springframework.batch.core.converter.DateToStringConverter;
import org.springframework.batch.core.converter.LocalDateTimeToStringConverter;
import org.springframework.batch.core.converter.LocalDateToStringConverter;
import org.springframework.batch.core.converter.LocalTimeToStringConverter;
import org.springframework.batch.core.converter.StringToDateConverter;
import org.springframework.batch.core.converter.StringToLocalDateConverter;
import org.springframework.batch.core.converter.StringToLocalDateTimeConverter;
import org.springframework.batch.core.converter.StringToLocalTimeConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.support.JobOperatorFactoryBean;
import org.springframework.batch.core.launch.support.TaskExecutorJobLauncher;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.dao.DefaultExecutionContextSerializer;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;

@Configuration(proxyBeanMethods=false)
@Import(value={ScopeConfiguration.class})
public class DefaultBatchConfiguration
implements ApplicationContextAware {
    @Autowired
    protected ApplicationContext applicationContext;
    private final JobRegistry jobRegistry = new MapJobRegistry();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public JobRepository jobRepository() throws BatchConfigurationException {
        JobRepositoryFactoryBean jobRepositoryFactoryBean = new JobRepositoryFactoryBean();
        try {
            jobRepositoryFactoryBean.setDataSource(this.getDataSource());
            jobRepositoryFactoryBean.setTransactionManager(this.getTransactionManager());
            jobRepositoryFactoryBean.setDatabaseType(this.getDatabaseType());
            jobRepositoryFactoryBean.setIncrementerFactory(this.getIncrementerFactory());
            jobRepositoryFactoryBean.setJobKeyGenerator(this.getJobKeyGenerator());
            jobRepositoryFactoryBean.setClobType(this.getClobType());
            jobRepositoryFactoryBean.setTablePrefix(this.getTablePrefix());
            jobRepositoryFactoryBean.setSerializer(this.getExecutionContextSerializer());
            jobRepositoryFactoryBean.setConversionService(this.getConversionService());
            jobRepositoryFactoryBean.setJdbcOperations(this.getJdbcOperations());
            jobRepositoryFactoryBean.setLobHandler(this.getLobHandler());
            jobRepositoryFactoryBean.setCharset(this.getCharset());
            jobRepositoryFactoryBean.setMaxVarCharLength(this.getMaxVarCharLength());
            jobRepositoryFactoryBean.setIsolationLevelForCreateEnum(this.getIsolationLevelForCreate());
            jobRepositoryFactoryBean.setValidateTransactionState(this.getValidateTransactionState());
            jobRepositoryFactoryBean.afterPropertiesSet();
            return jobRepositoryFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new BatchConfigurationException("Unable to configure the default job repository", e);
        }
    }

    @Bean
    public JobLauncher jobLauncher() throws BatchConfigurationException {
        TaskExecutorJobLauncher taskExecutorJobLauncher = new TaskExecutorJobLauncher();
        taskExecutorJobLauncher.setJobRepository(this.jobRepository());
        taskExecutorJobLauncher.setTaskExecutor(this.getTaskExecutor());
        try {
            taskExecutorJobLauncher.afterPropertiesSet();
            return taskExecutorJobLauncher;
        }
        catch (Exception e) {
            throw new BatchConfigurationException("Unable to configure the default job launcher", e);
        }
    }

    @Bean
    public JobExplorer jobExplorer() throws BatchConfigurationException {
        JobExplorerFactoryBean jobExplorerFactoryBean = new JobExplorerFactoryBean();
        jobExplorerFactoryBean.setDataSource(this.getDataSource());
        jobExplorerFactoryBean.setTransactionManager(this.getTransactionManager());
        jobExplorerFactoryBean.setJdbcOperations(this.getJdbcOperations());
        jobExplorerFactoryBean.setJobKeyGenerator(this.getJobKeyGenerator());
        jobExplorerFactoryBean.setCharset(this.getCharset());
        jobExplorerFactoryBean.setTablePrefix(this.getTablePrefix());
        jobExplorerFactoryBean.setLobHandler(this.getLobHandler());
        jobExplorerFactoryBean.setConversionService(this.getConversionService());
        jobExplorerFactoryBean.setSerializer(this.getExecutionContextSerializer());
        try {
            jobExplorerFactoryBean.afterPropertiesSet();
            return jobExplorerFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new BatchConfigurationException("Unable to configure the default job explorer", e);
        }
    }

    @Bean
    public JobRegistry jobRegistry() throws BatchConfigurationException {
        return this.jobRegistry;
    }

    @Bean
    public JobOperator jobOperator() throws BatchConfigurationException {
        JobOperatorFactoryBean jobOperatorFactoryBean = new JobOperatorFactoryBean();
        jobOperatorFactoryBean.setTransactionManager(this.getTransactionManager());
        jobOperatorFactoryBean.setJobRepository(this.jobRepository());
        jobOperatorFactoryBean.setJobExplorer(this.jobExplorer());
        jobOperatorFactoryBean.setJobRegistry(this.jobRegistry());
        jobOperatorFactoryBean.setJobLauncher(this.jobLauncher());
        try {
            jobOperatorFactoryBean.afterPropertiesSet();
            return jobOperatorFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new BatchConfigurationException("Unable to configure the default job operator", e);
        }
    }

    @Bean
    public JobRegistryBeanPostProcessor jobRegistryBeanPostProcessor() throws BatchConfigurationException {
        JobRegistryBeanPostProcessor jobRegistryBeanPostProcessor = new JobRegistryBeanPostProcessor();
        jobRegistryBeanPostProcessor.setJobRegistry(this.jobRegistry());
        try {
            jobRegistryBeanPostProcessor.afterPropertiesSet();
            return jobRegistryBeanPostProcessor;
        }
        catch (Exception e) {
            throw new BatchConfigurationException("Unable to configure the default job registry BeanPostProcessor", e);
        }
    }

    protected DataSource getDataSource() {
        String errorMessage = " To use the default configuration, a data source bean named 'dataSource' should be defined in the application context but none was found. Override getDataSource() to provide the data source to use for Batch meta-data.";
        if (this.applicationContext.getBeansOfType(DataSource.class).isEmpty()) {
            throw new BatchConfigurationException("Unable to find a DataSource bean in the application context." + errorMessage);
        }
        if (!this.applicationContext.containsBean("dataSource")) {
            throw new BatchConfigurationException(errorMessage);
        }
        return (DataSource)this.applicationContext.getBean("dataSource", DataSource.class);
    }

    protected PlatformTransactionManager getTransactionManager() {
        String errorMessage = " To use the default configuration, a transaction manager bean named 'transactionManager' should be defined in the application context but none was found. Override getTransactionManager() to provide the transaction manager to use for the job repository.";
        if (this.applicationContext.getBeansOfType(PlatformTransactionManager.class).isEmpty()) {
            throw new BatchConfigurationException("Unable to find a PlatformTransactionManager bean in the application context." + errorMessage);
        }
        if (!this.applicationContext.containsBean("transactionManager")) {
            throw new BatchConfigurationException(errorMessage);
        }
        return (PlatformTransactionManager)this.applicationContext.getBean("transactionManager", PlatformTransactionManager.class);
    }

    protected boolean getValidateTransactionState() {
        return true;
    }

    protected Isolation getIsolationLevelForCreate() {
        return Isolation.SERIALIZABLE;
    }

    protected int getMaxVarCharLength() {
        return 2500;
    }

    protected String getTablePrefix() {
        return "BATCH_";
    }

    protected Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    protected LobHandler getLobHandler() {
        return new DefaultLobHandler();
    }

    protected JdbcOperations getJdbcOperations() {
        return new JdbcTemplate(this.getDataSource());
    }

    protected ExecutionContextSerializer getExecutionContextSerializer() {
        return new DefaultExecutionContextSerializer();
    }

    protected int getClobType() {
        return 2005;
    }

    protected DataFieldMaxValueIncrementerFactory getIncrementerFactory() {
        return new DefaultDataFieldMaxValueIncrementerFactory(this.getDataSource());
    }

    protected JobKeyGenerator getJobKeyGenerator() {
        return new DefaultJobKeyGenerator();
    }

    protected String getDatabaseType() throws MetaDataAccessException {
        return DatabaseType.fromMetaData((DataSource)this.getDataSource()).name();
    }

    protected TaskExecutor getTaskExecutor() {
        return new SyncTaskExecutor();
    }

    protected ConfigurableConversionService getConversionService() {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter((Converter)new DateToStringConverter());
        conversionService.addConverter((Converter)new StringToDateConverter());
        conversionService.addConverter((Converter)new LocalDateToStringConverter());
        conversionService.addConverter((Converter)new StringToLocalDateConverter());
        conversionService.addConverter((Converter)new LocalTimeToStringConverter());
        conversionService.addConverter((Converter)new StringToLocalTimeConverter());
        conversionService.addConverter((Converter)new LocalDateTimeToStringConverter());
        conversionService.addConverter((Converter)new StringToLocalDateTimeConverter());
        return conversionService;
    }
}

