/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.StepHandler;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.lang.Nullable;

public class JobFlowExecutor
implements FlowExecutor {
    private final ThreadLocal<StepExecution> stepExecutionHolder = new ThreadLocal();
    private final JobExecution execution;
    protected ExitStatus exitStatus = ExitStatus.EXECUTING;
    private final StepHandler stepHandler;
    private final JobRepository jobRepository;

    public JobFlowExecutor(JobRepository jobRepository, StepHandler stepHandler, JobExecution execution) {
        this.jobRepository = jobRepository;
        this.stepHandler = stepHandler;
        this.execution = execution;
        this.stepExecutionHolder.set(null);
    }

    @Override
    public String executeStep(Step step) throws JobInterruptedException, JobRestartException, StartLimitExceededException {
        boolean isRerun = this.isStepRestart(step);
        StepExecution stepExecution = this.stepHandler.handleStep(step, this.execution);
        this.stepExecutionHolder.set(stepExecution);
        if (stepExecution == null) {
            return ExitStatus.COMPLETED.getExitCode();
        }
        if (stepExecution.isTerminateOnly()) {
            throw new JobInterruptedException("Step requested termination: " + stepExecution, stepExecution.getStatus());
        }
        if (isRerun) {
            stepExecution.getExecutionContext().put("batch.restart", (Object)true);
        }
        return stepExecution.getExitStatus().getExitCode();
    }

    private boolean isStepRestart(Step step) {
        long count = this.jobRepository.getStepExecutionCount(this.execution.getJobInstance(), step.getName());
        return count > 0L;
    }

    @Override
    public void abandonStepExecution() {
        StepExecution lastStepExecution = this.stepExecutionHolder.get();
        if (lastStepExecution != null && lastStepExecution.getStatus().isGreaterThan(BatchStatus.STOPPING)) {
            lastStepExecution.upgradeStatus(BatchStatus.ABANDONED);
            this.jobRepository.update(lastStepExecution);
        }
    }

    @Override
    public void updateJobExecutionStatus(FlowExecutionStatus status) {
        this.execution.setStatus(this.findBatchStatus(status));
        this.exitStatus = this.exitStatus.and(new ExitStatus(status.getName()));
        this.execution.setExitStatus(this.exitStatus);
    }

    @Override
    public JobExecution getJobExecution() {
        return this.execution;
    }

    @Override
    @Nullable
    public StepExecution getStepExecution() {
        return this.stepExecutionHolder.get();
    }

    @Override
    public void close(FlowExecution result) {
        this.stepExecutionHolder.set(null);
    }

    @Override
    public boolean isRestart() {
        if (this.getStepExecution() != null && this.getStepExecution().getStatus() == BatchStatus.ABANDONED) {
            return true;
        }
        return this.execution.getStepExecutions().isEmpty();
    }

    @Override
    public void addExitStatus(String code) {
        this.exitStatus = this.exitStatus.and(new ExitStatus(code));
    }

    protected BatchStatus findBatchStatus(FlowExecutionStatus status) {
        for (BatchStatus batchStatus : BatchStatus.values()) {
            if (!status.getName().startsWith(batchStatus.toString())) continue;
            return batchStatus;
        }
        return BatchStatus.UNKNOWN;
    }
}

