/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.lang.Nullable;

public class RunIdIncrementer
implements JobParametersIncrementer {
    private static final String RUN_ID_KEY = "run.id";
    private String key = "run.id";

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public JobParameters getNext(@Nullable JobParameters parameters) {
        JobParameters params = parameters == null ? new JobParameters() : parameters;
        JobParameter<?> runIdParameter = params.getParameters().get(this.key);
        long id = 1L;
        if (runIdParameter != null) {
            try {
                id = Long.parseLong(runIdParameter.getValue().toString()) + 1L;
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Invalid value for parameter " + this.key, exception);
            }
        }
        return new JobParametersBuilder(params).addLong(this.key, id).toJobParameters();
    }
}

