/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.listener.OrderedComposite;
import org.springframework.batch.item.Chunk;

public class CompositeItemWriteListener<S>
implements ItemWriteListener<S> {
    private final OrderedComposite<ItemWriteListener<? super S>> listeners = new OrderedComposite();

    public void setListeners(List<? extends ItemWriteListener<? super S>> itemWriteListeners) {
        this.listeners.setItems(itemWriteListeners);
    }

    public void register(ItemWriteListener<? super S> itemWriteListener) {
        this.listeners.add(itemWriteListener);
    }

    @Override
    public void afterWrite(Chunk<? extends S> items) {
        Iterator<ItemWriteListener<S>> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ItemWriteListener<? extends S> listener = iterator.next();
            listener.afterWrite(items);
        }
    }

    @Override
    public void beforeWrite(Chunk<? extends S> items) {
        Iterator<ItemWriteListener<S>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemWriteListener<? extends S> listener = iterator.next();
            listener.beforeWrite(items);
        }
    }

    @Override
    public void onWriteError(Exception ex, Chunk<? extends S> items) {
        Iterator<ItemWriteListener<S>> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ItemWriteListener<? extends S> listener = iterator.next();
            listener.onWriteError(ex, items);
        }
    }
}

