/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.lang.Nullable;

public interface JobRepository {
    default public List<String> getJobNames() {
        return Collections.emptyList();
    }

    default public List<JobInstance> findJobInstancesByName(String jobName, int start, int count) {
        return Collections.emptyList();
    }

    default public List<JobExecution> findJobExecutions(JobInstance jobInstance) {
        return Collections.emptyList();
    }

    public boolean isJobInstanceExists(String var1, JobParameters var2);

    public JobInstance createJobInstance(String var1, JobParameters var2);

    public JobExecution createJobExecution(String var1, JobParameters var2) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException;

    public void update(JobExecution var1);

    public void add(StepExecution var1);

    public void addAll(Collection<StepExecution> var1);

    public void update(StepExecution var1);

    public void updateExecutionContext(StepExecution var1);

    public void updateExecutionContext(JobExecution var1);

    @Nullable
    default public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public StepExecution getLastStepExecution(JobInstance var1, String var2);

    public long getStepExecutionCount(JobInstance var1, String var2);

    @Nullable
    public JobExecution getLastJobExecution(String var1, JobParameters var2);

    default public void deleteStepExecution(StepExecution stepExecution) {
        throw new UnsupportedOperationException();
    }

    default public void deleteJobExecution(JobExecution jobExecution) {
        throw new UnsupportedOperationException();
    }

    default public void deleteJobInstance(JobInstance jobInstance) {
        throw new UnsupportedOperationException();
    }
}

