/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.repeat.context.SynchronizedAttributeAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class StepContext
extends SynchronizedAttributeAccessor {
    private final StepExecution stepExecution;
    private final Map<String, Set<Runnable>> callbacks = new HashMap<String, Set<Runnable>>();

    public StepContext(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution, (String)"A StepContext must have a non-null StepExecution");
        this.stepExecution = stepExecution;
    }

    public String getStepName() {
        return this.stepExecution.getStepName();
    }

    public String getJobName() {
        Assert.state((this.stepExecution.getJobExecution() != null ? 1 : 0) != 0, (String)"StepExecution does not have a JobExecution");
        Assert.state((this.stepExecution.getJobExecution().getJobInstance() != null ? 1 : 0) != 0, (String)"StepExecution does not have a JobInstance");
        return this.stepExecution.getJobExecution().getJobInstance().getJobName();
    }

    public Long getJobInstanceId() {
        Assert.state((this.stepExecution.getJobExecution() != null ? 1 : 0) != 0, (String)"StepExecution does not have a JobExecution");
        Assert.state((this.stepExecution.getJobExecution().getJobInstance() != null ? 1 : 0) != 0, (String)"StepExecution does not have a JobInstance");
        return this.stepExecution.getJobExecution().getJobInstance().getInstanceId();
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public Map<String, Object> getStepExecutionContext() {
        return this.stepExecution.getExecutionContext().toMap();
    }

    public Map<String, Object> getJobExecutionContext() {
        return this.stepExecution.getJobExecution().getExecutionContext().toMap();
    }

    public Map<String, Object> getJobParameters() {
        HashMap result = new HashMap();
        for (Map.Entry<String, JobParameter<?>> entry : this.stepExecution.getJobParameters().getParameters().entrySet()) {
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            Set set = this.callbacks.computeIfAbsent(name, k -> new HashSet());
            set.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterDestructionCallbacks(String name) {
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            this.callbacks.remove(name);
        }
    }

    @Nullable
    public Object removeAttribute(String name) {
        this.unregisterDestructionCallbacks(name);
        return super.removeAttribute(name);
    }

    public void close() {
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        Map<String, Set<Runnable>> copy = Collections.unmodifiableMap(this.callbacks);
        for (Map.Entry<String, Set<Runnable>> entry : copy.entrySet()) {
            Set<Runnable> set = entry.getValue();
            for (Runnable callback : set) {
                if (callback == null) continue;
                try {
                    callback.run();
                }
                catch (RuntimeException t) {
                    errors.add(t);
                }
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        Exception error = (Exception)errors.get(0);
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new UnexpectedJobExecutionException("Could not close step context, rethrowing first of " + errors.size() + " exceptions.", error);
    }

    public StepExecution getStepExecution() {
        return this.stepExecution;
    }

    public String getId() {
        Assert.state((this.stepExecution.getId() != null ? 1 : 0) != 0, (String)"StepExecution has no id.  It must be saved before it can be used in step scope.");
        return "execution#" + this.stepExecution.getId();
    }

    public boolean equals(Object other) {
        if (!(other instanceof StepContext)) {
            return false;
        }
        StepContext context = (StepContext)((Object)other);
        if (other == this) {
            return true;
        }
        if (context.stepExecution == this.stepExecution) {
            return true;
        }
        return this.stepExecution.equals(context.stepExecution);
    }

    public int hashCode() {
        return this.stepExecution.hashCode();
    }

    public String toString() {
        return super.toString() + ", stepExecutionContext=" + this.getStepExecutionContext() + ", jobExecutionContext=" + this.getJobExecutionContext() + ", jobParameters=" + this.getJobParameters();
    }
}

