/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;

public class SimpleRetryExceptionHandler
implements RetryListener,
ExceptionHandler {
    private static final String EXHAUSTED = SimpleRetryExceptionHandler.class.getName() + ".RETRY_EXHAUSTED";
    private static final Log logger = LogFactory.getLog(SimpleRetryExceptionHandler.class);
    private final RetryPolicy retryPolicy;
    private final ExceptionHandler exceptionHandler;
    private final BinaryExceptionClassifier fatalExceptionClassifier;

    public SimpleRetryExceptionHandler(RetryPolicy retryPolicy, ExceptionHandler exceptionHandler, Collection<Class<? extends Throwable>> fatalExceptionClasses) {
        this.retryPolicy = retryPolicy;
        this.exceptionHandler = exceptionHandler;
        this.fatalExceptionClassifier = new BinaryExceptionClassifier(fatalExceptionClasses);
    }

    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        if (this.fatalExceptionClassifier.classify(throwable).booleanValue() || context.hasAttribute(EXHAUSTED)) {
            logger.debug((Object)"Handled fatal exception");
            this.exceptionHandler.handleException(context, throwable);
        } else {
            logger.debug((Object)"Handled non-fatal exception", throwable);
        }
    }

    public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        if (!this.retryPolicy.canRetry(context)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Marking retry as exhausted: " + context));
            }
            this.getRepeatContext().setAttribute(EXHAUSTED, (Object)"true");
        }
    }

    private RepeatContext getRepeatContext() {
        RepeatContext context = RepeatSynchronizationManager.getContext();
        if (context.getParent() != null) {
            return context.getParent();
        }
        return context;
    }
}

