/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import com.sun.jna.Platform;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.http.HttpHost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.springframework.boot.buildpack.platform.docker.configuration.ResolvedDockerHost;
import org.springframework.boot.buildpack.platform.docker.transport.HttpClientTransport;
import org.springframework.boot.buildpack.platform.socket.DomainSocket;
import org.springframework.boot.buildpack.platform.socket.NamedPipeSocket;

final class LocalHttpClientTransport
extends HttpClientTransport {
    private static final HttpHost LOCAL_DOCKER_HOST = HttpHost.create((String)"docker://localhost");

    private LocalHttpClientTransport(CloseableHttpClient client) {
        super(client, LOCAL_DOCKER_HOST);
    }

    static LocalHttpClientTransport create(ResolvedDockerHost dockerHost) {
        HttpClientBuilder builder = HttpClients.custom();
        builder.setConnectionManager((HttpClientConnectionManager)new LocalConnectionManager(dockerHost.getAddress()));
        builder.setSchemePortResolver((SchemePortResolver)new LocalSchemePortResolver());
        return new LocalHttpClientTransport(builder.build());
    }

    private static class LocalSchemePortResolver
    implements SchemePortResolver {
        private static final int DEFAULT_DOCKER_PORT = 2376;

        private LocalSchemePortResolver() {
        }

        public int resolve(HttpHost host) throws UnsupportedSchemeException {
            Args.notNull((Object)host, (String)"HTTP host");
            String name = host.getSchemeName();
            if ("docker".equals(name)) {
                return 2376;
            }
            throw new UnsupportedSchemeException(name + " protocol is not supported");
        }
    }

    private static class LocalConnectionSocketFactory
    implements ConnectionSocketFactory {
        private final String host;

        LocalConnectionSocketFactory(String host) {
            this.host = host;
        }

        public Socket createSocket(HttpContext context) throws IOException {
            if (Platform.isWindows()) {
                return NamedPipeSocket.get(this.host);
            }
            return DomainSocket.get(this.host);
        }

        public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            return sock;
        }
    }

    private static class LocalDnsResolver
    implements DnsResolver {
        private static final InetAddress[] LOOPBACK = new InetAddress[]{InetAddress.getLoopbackAddress()};

        private LocalDnsResolver() {
        }

        public InetAddress[] resolve(String host) throws UnknownHostException {
            return LOOPBACK;
        }
    }

    private static class LocalConnectionManager
    extends BasicHttpClientConnectionManager {
        LocalConnectionManager(String host) {
            super(LocalConnectionManager.getRegistry(host), null, null, (DnsResolver)new LocalDnsResolver());
        }

        private static Registry<ConnectionSocketFactory> getRegistry(String host) {
            RegistryBuilder builder = RegistryBuilder.create();
            builder.register("docker", (Object)new LocalConnectionSocketFactory(host));
            return builder.build();
        }
    }
}

