/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core;

import java.util.regex.Pattern;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class Path {
    private static final String SLASH = "/";
    private static final String MATCH_PATTERN = "/?%s";
    private final String path;

    public Path(String path) {
        this(path, true);
    }

    private Path(String path, boolean cleanUp) {
        this.path = cleanUp ? Path.cleanUp(path) : path;
    }

    public boolean matches(String reference) {
        return reference == null ? false : this.path.matches(String.format(MATCH_PATTERN, Pattern.quote(reference)));
    }

    public Path slash(String path) {
        return new Path(this.path + Path.cleanUp(path), false);
    }

    public Path slash(Path path) {
        return this.slash(path.toString());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private static String cleanUp(String path) {
        if (!StringUtils.hasText((String)path)) {
            return "";
        }
        String trimmed = path.trim().replaceAll(" ", "");
        while (trimmed.endsWith(SLASH)) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return (trimmed = trimmed.substring(Path.getFirstNoneSlashIndex(trimmed))).contains("://") ? trimmed : SLASH + trimmed;
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path that = (Path)obj;
        return this.path.equals(that.path);
    }

    private static int getFirstNoneSlashIndex(String input) {
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '/') continue;
            return i;
        }
        return input.length();
    }
}

