/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.RepositoryConstraintViolationException;
import org.springframework.data.rest.core.ValidationErrors;
import org.springframework.data.rest.core.event.AbstractRepositoryEventListener;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class ValidatingRepositoryEventListener
extends AbstractRepositoryEventListener<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidatingRepositoryEventListener.class);
    private final ObjectFactory<PersistentEntities> persistentEntitiesFactory;
    private final MultiValueMap<String, Validator> validators;

    public ValidatingRepositoryEventListener(ObjectFactory<PersistentEntities> persistentEntitiesFactory) {
        Assert.notNull(persistentEntitiesFactory, (String)"PersistentEntities must not be null");
        this.persistentEntitiesFactory = persistentEntitiesFactory;
        this.validators = new LinkedMultiValueMap();
    }

    public ValidatingRepositoryEventListener setValidators(Map<String, Collection<Validator>> validators) {
        for (Map.Entry<String, Collection<Validator>> entry : validators.entrySet()) {
            this.validators.put((Object)entry.getKey(), new ArrayList<Validator>(entry.getValue()));
        }
        return this;
    }

    public ValidatingRepositoryEventListener addValidator(String event, Validator validator) {
        this.validators.add((Object)event, (Object)validator);
        return this;
    }

    @Override
    protected void onBeforeCreate(Object entity) {
        this.validate("beforeCreate", entity);
    }

    @Override
    protected void onAfterCreate(Object entity) {
        this.validate("afterCreate", entity);
    }

    @Override
    protected void onBeforeSave(Object entity) {
        this.validate("beforeSave", entity);
    }

    @Override
    protected void onAfterSave(Object entity) {
        this.validate("afterSave", entity);
    }

    @Override
    protected void onBeforeLinkSave(Object parent, Object linked) {
        this.validate("beforeLinkSave", parent);
    }

    @Override
    protected void onAfterLinkSave(Object parent, Object linked) {
        this.validate("afterLinkSave", parent);
    }

    @Override
    protected void onBeforeDelete(Object entity) {
        this.validate("beforeDelete", entity);
    }

    @Override
    protected void onAfterDelete(Object entity) {
        this.validate("afterDelete", entity);
    }

    private Errors validate(String event, Object entity) {
        if (entity == null) {
            return null;
        }
        ValidationErrors errors = new ValidationErrors(entity, (PersistentEntities)this.persistentEntitiesFactory.getObject());
        for (Validator validator : this.getValidatorsForEvent(event)) {
            if (!validator.supports(entity.getClass())) continue;
            LOGGER.debug("{}: {} with {}", new Object[]{event, entity, validator});
            ValidationUtils.invokeValidator((Validator)validator, (Object)entity, (Errors)errors);
        }
        if (errors.hasErrors()) {
            throw new RepositoryConstraintViolationException((Errors)errors);
        }
        return errors;
    }

    private Collection<Validator> getValidatorsForEvent(String event) {
        Collection validators = (Collection)this.validators.get((Object)event);
        return validators == null ? Collections.emptySet() : validators;
    }
}

