/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.rest.core.mapping.ConfigurableHttpMethods;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public interface HttpMethods
extends Streamable<HttpMethod> {
    public static HttpMethods none() {
        return ConfigurableHttpMethods.NONE;
    }

    public static HttpMethods of(Collection<HttpMethod> methods) {
        Assert.notNull(methods, (String)"HTTP methods must not be null");
        return ConfigurableHttpMethods.of(methods);
    }

    public boolean contains(HttpMethod var1);

    default public Set<HttpMethod> toSet() {
        return (Set)this.stream().collect(StreamUtils.toUnmodifiableSet());
    }

    default public HttpMethods and(HttpMethod ... method) {
        return HttpMethods.of(Stream.concat(this.stream(), Arrays.stream(method)).collect(Collectors.toSet()));
    }

    default public HttpMethods butWithout(HttpMethod ... method) {
        List<HttpMethod> toRemove = Arrays.asList(method);
        return HttpMethods.of(this.stream().filter(it -> !toRemove.contains(it)).collect(Collectors.toSet()));
    }
}

