/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.annotation.Order;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.util.Assert;

@Order(value=-2147483639)
public class RepositoryRelProvider
implements LinkRelationProvider {
    private final ObjectFactory<ResourceMappings> mappings;

    public RepositoryRelProvider(ObjectFactory<ResourceMappings> mappings) {
        Assert.notNull(mappings, (String)"ResourceMappings must not be null");
        this.mappings = mappings;
    }

    public LinkRelation getCollectionResourceRelFor(Class<?> type) {
        return ((ResourceMappings)this.mappings.getObject()).getMetadataFor(type).getRel();
    }

    public LinkRelation getItemResourceRelFor(Class<?> type) {
        return ((ResourceMappings)this.mappings.getObject()).getMetadataFor(type).getItemResourceRel();
    }

    public boolean supports(LinkRelationProvider.LookupContext context) {
        return ((ResourceMappings)this.mappings.getObject()).hasMappingFor(context.getType());
    }
}

