/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import reactor.core.publisher.Mono;

public class AuthenticatedReactiveAuthorizationManager<T>
implements ReactiveAuthorizationManager<T> {
    private AuthenticationTrustResolver authTrustResolver = new AuthenticationTrustResolverImpl();

    @Override
    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, T object) {
        return authentication.filter(this::isNotAnonymous).map(a -> new AuthorizationDecision(a.isAuthenticated())).defaultIfEmpty((Object)new AuthorizationDecision(false));
    }

    private boolean isNotAnonymous(Authentication authentication) {
        return !this.authTrustResolver.isAnonymous(authentication);
    }

    public static <T> AuthenticatedReactiveAuthorizationManager<T> authenticated() {
        return new AuthenticatedReactiveAuthorizationManager<T>();
    }

    private AuthenticatedReactiveAuthorizationManager() {
    }
}

