/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import org.springframework.web.socket.sockjs.transport.TransportHandlingSockJsService;
import org.springframework.web.socket.sockjs.transport.handler.DefaultSockJsService;
import org.springframework.web.socket.sockjs.transport.handler.WebSocketTransportHandler;
import org.w3c.dom.Element;

class WebSocketNamespaceUtils {
    WebSocketNamespaceUtils() {
    }

    public static RuntimeBeanReference registerHandshakeHandler(Element element, ParserContext parserContext, Object source) {
        RuntimeBeanReference handlerRef;
        Element handlerElem = DomUtils.getChildElementByTagName((Element)element, (String)"handshake-handler");
        if (handlerElem != null) {
            handlerRef = new RuntimeBeanReference(handlerElem.getAttribute("ref"));
        } else {
            RootBeanDefinition defaultHandlerDef = new RootBeanDefinition(DefaultHandshakeHandler.class);
            defaultHandlerDef.setSource(source);
            defaultHandlerDef.setRole(2);
            String handlerName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)defaultHandlerDef);
            handlerRef = new RuntimeBeanReference(handlerName);
        }
        return handlerRef;
    }

    public static RuntimeBeanReference registerSockJsService(Element element, String sockJsSchedulerName, ParserContext parserContext, Object source) {
        Element sockJsElement = DomUtils.getChildElementByTagName((Element)element, (String)"sockjs");
        if (sockJsElement != null) {
            Element handshakeHandlerElement = DomUtils.getChildElementByTagName((Element)element, (String)"handshake-handler");
            RootBeanDefinition sockJsServiceDef = new RootBeanDefinition(DefaultSockJsService.class);
            sockJsServiceDef.setSource(source);
            String customTaskSchedulerName = sockJsElement.getAttribute("scheduler");
            RuntimeBeanReference scheduler = !customTaskSchedulerName.isEmpty() ? new RuntimeBeanReference(customTaskSchedulerName) : WebSocketNamespaceUtils.registerSockJsTaskScheduler(sockJsSchedulerName, parserContext, source);
            sockJsServiceDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)scheduler);
            Element transportHandlersElement = DomUtils.getChildElementByTagName((Element)sockJsElement, (String)"transport-handlers");
            if (transportHandlersElement != null) {
                String registerDefaultsAttribute = transportHandlersElement.getAttribute("register-defaults");
                if (registerDefaultsAttribute.equals("false")) {
                    sockJsServiceDef.setBeanClass(TransportHandlingSockJsService.class);
                }
                ManagedList<? super Object> transportHandlersList = WebSocketNamespaceUtils.parseBeanSubElements(transportHandlersElement, parserContext);
                sockJsServiceDef.getConstructorArgumentValues().addIndexedArgumentValue(1, transportHandlersList);
            } else if (handshakeHandlerElement != null) {
                RuntimeBeanReference handshakeHandlerRef = new RuntimeBeanReference(handshakeHandlerElement.getAttribute("ref"));
                RootBeanDefinition wsTransportHandler = new RootBeanDefinition(WebSocketTransportHandler.class);
                wsTransportHandler.setSource(source);
                wsTransportHandler.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)handshakeHandlerRef);
                sockJsServiceDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)wsTransportHandler);
            }
            String attrValue = sockJsElement.getAttribute("name");
            if (!attrValue.isEmpty()) {
                sockJsServiceDef.getPropertyValues().add("name", (Object)attrValue);
            }
            if (!(attrValue = sockJsElement.getAttribute("websocket-enabled")).isEmpty()) {
                sockJsServiceDef.getPropertyValues().add("webSocketEnabled", (Object)Boolean.valueOf(attrValue));
            }
            if (!(attrValue = sockJsElement.getAttribute("session-cookie-needed")).isEmpty()) {
                sockJsServiceDef.getPropertyValues().add("sessionCookieNeeded", (Object)Boolean.valueOf(attrValue));
            }
            if (!(attrValue = sockJsElement.getAttribute("stream-bytes-limit")).isEmpty()) {
                sockJsServiceDef.getPropertyValues().add("streamBytesLimit", (Object)Integer.valueOf(attrValue));
            }
            if (!(attrValue = sockJsElement.getAttribute("disconnect-delay")).isEmpty()) {
                sockJsServiceDef.getPropertyValues().add("disconnectDelay", (Object)Long.valueOf(attrValue));
            }
            if (!(attrValue = sockJsElement.getAttribute("message-cache-size")).isEmpty()) {
                sockJsServiceDef.getPropertyValues().add("httpMessageCacheSize", (Object)Integer.valueOf(attrValue));
            }
            if (!(attrValue = sockJsElement.getAttribute("heartbeat-time")).isEmpty()) {
                sockJsServiceDef.getPropertyValues().add("heartbeatTime", (Object)Long.valueOf(attrValue));
            }
            sockJsServiceDef.setRole(2);
            String sockJsServiceName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)sockJsServiceDef);
            return new RuntimeBeanReference(sockJsServiceName);
        }
        return null;
    }

    private static RuntimeBeanReference registerSockJsTaskScheduler(String schedulerName, ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(schedulerName)) {
            RootBeanDefinition taskSchedulerDef = new RootBeanDefinition(ThreadPoolTaskScheduler.class);
            taskSchedulerDef.setSource(source);
            taskSchedulerDef.setRole(2);
            taskSchedulerDef.getPropertyValues().add("poolSize", (Object)Runtime.getRuntime().availableProcessors());
            taskSchedulerDef.getPropertyValues().add("removeOnCancelPolicy", (Object)true);
            taskSchedulerDef.getPropertyValues().add("threadNamePrefix", (Object)(schedulerName + "-"));
            parserContext.getRegistry().registerBeanDefinition(schedulerName, (BeanDefinition)taskSchedulerDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)taskSchedulerDef, schedulerName));
        }
        return new RuntimeBeanReference(schedulerName);
    }

    public static ManagedList<? super Object> parseBeanSubElements(Element parentElement, ParserContext parserContext) {
        ManagedList beans = new ManagedList();
        if (parentElement != null) {
            beans.setSource(parserContext.extractSource((Object)parentElement));
            for (Element beanElement : DomUtils.getChildElementsByTagName((Element)parentElement, (String[])new String[]{"bean", "ref"})) {
                Object object = parserContext.getDelegate().parsePropertySubElement(beanElement, null);
                beans.add(object);
            }
        }
        return beans;
    }
}

