/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.comparison;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

public abstract class DiffMarkupPolicy {
    private static final int BITS_PER_PIXEL = 8;
    private static final int COLOR_MAP_SIZE = 2;
    private static final int TRANSPARENT_COLOR_INDEX = 0;
    protected boolean marked = false;
    protected int diffSizeTrigger;
    protected BufferedImage diffImage;
    protected Color diffColor = Color.RED;

    public DiffMarkupPolicy withDiffColor(Color diffColor) {
        this.diffColor = diffColor;
        return this;
    }

    public abstract BufferedImage getMarkedImage();

    public abstract BufferedImage getTransparentMarkedImage();

    public abstract void addDiffPoint(int var1, int var2);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean hasDiff();

    public abstract int getDiffSize();

    public void setDiffImage(BufferedImage diffImage) {
        this.diffImage = diffImage;
    }

    public void setDiffSizeTrigger(int diffSizeTrigger) {
        this.diffSizeTrigger = diffSizeTrigger;
    }

    public BufferedImage getDiffImage() {
        return this.diffImage;
    }

    private IndexColorModel getColorModel() {
        return new IndexColorModel(8, 2, this.getColorMap(), 0, false, 0);
    }

    private byte[] getColorMap() {
        Color negativeColor = new Color(0xFFFFFF - this.diffColor.getRGB());
        return new byte[]{(byte)negativeColor.getRed(), (byte)negativeColor.getGreen(), (byte)negativeColor.getBlue(), (byte)this.diffColor.getRed(), (byte)this.diffColor.getGreen(), (byte)this.diffColor.getBlue()};
    }

    protected BufferedImage getTransparentDiffImage(BufferedImage diffImage) {
        return new BufferedImage(diffImage.getWidth(), diffImage.getHeight(), 13, this.getColorModel());
    }
}

