/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.comparison;

import java.awt.image.BufferedImage;
import ru.yandex.qatools.ashot.comparison.DiffMarkupPolicy;

public class ImageMarkupPolicy
extends DiffMarkupPolicy {
    private int diffPointCount;
    private int xReference = Integer.MAX_VALUE;
    private int yReference = Integer.MAX_VALUE;
    private int xSum;
    private int ySum;
    private BufferedImage transparentDiffImage;

    @Override
    public void setDiffImage(BufferedImage diffImage) {
        super.setDiffImage(diffImage);
        this.transparentDiffImage = this.getTransparentDiffImage(diffImage);
    }

    @Override
    public BufferedImage getMarkedImage() {
        if (!this.marked) {
            int rgb = this.diffColor.getRGB();
            for (int x = 0; x < this.diffImage.getWidth(); ++x) {
                for (int y = 0; y < this.diffImage.getHeight(); ++y) {
                    if (this.transparentDiffImage.getRGB(x, y) != rgb) continue;
                    this.diffImage.setRGB(x, y, rgb);
                }
            }
            this.marked = true;
        }
        return this.diffImage;
    }

    @Override
    public BufferedImage getTransparentMarkedImage() {
        return this.transparentDiffImage;
    }

    @Override
    public void addDiffPoint(int x, int y) {
        ++this.diffPointCount;
        this.xReference = Math.min(this.xReference, x);
        this.yReference = Math.min(this.yReference, y);
        this.xSum += x;
        this.ySum += y;
        this.transparentDiffImage.setRGB(x, y, this.diffColor.getRGB());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ImageMarkupPolicy) {
            ImageMarkupPolicy item = (ImageMarkupPolicy)obj;
            return this.diffPointCount == item.diffPointCount && this.xSum - this.diffPointCount * this.xReference == item.xSum - item.diffPointCount * item.xReference && this.ySum - this.diffPointCount * this.yReference == item.ySum - item.diffPointCount * item.yReference;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.diffPointCount;
        result = 31 * result + this.xSum - this.diffPointCount * this.xReference;
        result = 31 * result + this.ySum - this.diffPointCount * this.yReference;
        return result;
    }

    @Override
    public boolean hasDiff() {
        return this.diffPointCount > this.diffSizeTrigger;
    }

    @Override
    public int getDiffSize() {
        return this.diffPointCount;
    }
}

