/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.cropper;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Set;
import ru.yandex.qatools.ashot.Screenshot;
import ru.yandex.qatools.ashot.coordinates.Coords;
import ru.yandex.qatools.ashot.cropper.ImageCropper;

public class DefaultCropper
extends ImageCropper {
    @Override
    public Screenshot cropScreenshot(BufferedImage image, Set<Coords> coordsToCompare) {
        Coords cropArea = Coords.unity(coordsToCompare);
        Coords imageIntersection = Coords.ofImage(image).intersection(cropArea);
        if (imageIntersection.isEmpty()) {
            return new Screenshot(image);
        }
        BufferedImage cropped = new BufferedImage(imageIntersection.width, imageIntersection.height, image.getType());
        Graphics g = cropped.getGraphics();
        g.drawImage(image, 0, 0, imageIntersection.width, imageIntersection.height, cropArea.x, cropArea.y, cropArea.x + imageIntersection.width, cropArea.y + imageIntersection.height, null);
        g.dispose();
        Screenshot screenshot = new Screenshot(cropped);
        screenshot.setOriginShift(cropArea);
        screenshot.setCoordsToCompare(Coords.setReferenceCoords(screenshot.getOriginShift(), coordsToCompare));
        return screenshot;
    }

    protected Coords createCropArea(Set<Coords> coordsToCompare) {
        return Coords.unity(coordsToCompare);
    }
}

