/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.shooting;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Set;
import org.openqa.selenium.WebDriver;
import ru.yandex.qatools.ashot.coordinates.Coords;
import ru.yandex.qatools.ashot.shooting.ShootingStrategy;
import ru.yandex.qatools.ashot.shooting.cutter.CutStrategy;

public class RotatingDecorator
implements ShootingStrategy {
    private CutStrategy cutStrategy;
    private ShootingStrategy shootingStrategy;

    public RotatingDecorator(CutStrategy cutStrategy, ShootingStrategy shootingStrategy) {
        this.cutStrategy = cutStrategy;
        this.shootingStrategy = shootingStrategy;
    }

    @Override
    public BufferedImage getScreenshot(WebDriver wd) {
        return this.rotate(this.shootingStrategy.getScreenshot(wd), wd);
    }

    @Override
    public BufferedImage getScreenshot(WebDriver wd, Set<Coords> coords) {
        return this.getScreenshot(wd);
    }

    @Override
    public Set<Coords> prepareCoords(Set<Coords> coordsSet) {
        return coordsSet;
    }

    private BufferedImage rotate(BufferedImage baseImage, WebDriver wd) {
        BufferedImage rotated = new BufferedImage(baseImage.getHeight(), baseImage.getWidth(), 6);
        Graphics2D graphics = rotated.createGraphics();
        double theta = 4.71238898038469;
        int origin = baseImage.getWidth() / 2;
        graphics.rotate(theta, origin, origin);
        graphics.drawImage(baseImage, null, 0, 0);
        int rotatedHeight = rotated.getHeight();
        int rotatedWidth = rotated.getWidth();
        int headerToCut = this.cutStrategy.getHeaderHeight(wd);
        return rotated.getSubimage(0, headerToCut, rotatedWidth, rotatedHeight - headerToCut);
    }
}

