/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.shooting;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Set;
import org.openqa.selenium.WebDriver;
import ru.yandex.qatools.ashot.coordinates.Coords;
import ru.yandex.qatools.ashot.shooting.ShootingDecorator;
import ru.yandex.qatools.ashot.shooting.ShootingStrategy;

public class ScalingDecorator
extends ShootingDecorator {
    private static final Float STANDARD_DRP = Float.valueOf(1.0f);
    private Float dprX = STANDARD_DRP;
    private Float dprY = STANDARD_DRP;

    public ScalingDecorator(ShootingStrategy strategy) {
        super(strategy);
    }

    @Override
    public BufferedImage getScreenshot(WebDriver wd) {
        return this.scale(this.getShootingStrategy().getScreenshot(wd));
    }

    @Override
    public BufferedImage getScreenshot(WebDriver wd, Set<Coords> coords) {
        return this.scale(this.getShootingStrategy().getScreenshot(wd, coords));
    }

    public ScalingDecorator withDprX(float dprX) {
        this.dprX = Float.valueOf(dprX);
        return this;
    }

    public ScalingDecorator withDprY(float dprY) {
        this.dprY = Float.valueOf(dprY);
        return this;
    }

    public ScalingDecorator withDpr(float dpr) {
        return this.withDprX(dpr).withDprY(dpr);
    }

    private BufferedImage scale(BufferedImage image) {
        if (STANDARD_DRP.equals(this.dprY) && STANDARD_DRP.equals(this.dprX)) {
            return image;
        }
        int scaledWidth = (int)((float)image.getWidth() / this.dprX.floatValue());
        int scaledHeight = (int)((float)image.getHeight() / this.dprY.floatValue());
        BufferedImage bufferedImage = new BufferedImage(scaledWidth, scaledHeight, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

