/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.core.exception;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.DebugUtil;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;
import uk.gov.gchq.gaffer.core.exception.Status;
import uk.gov.gchq.gaffer.core.exception.serialisation.StatusDeserialiser;
import uk.gov.gchq.gaffer.core.exception.serialisation.StatusSerialiser;

@JsonDeserialize(builder=ErrorBuilder.class)
public final class Error {
    private final int statusCode;
    private final Status status;
    private final String simpleMessage;
    private final String detailMessage;

    private Error(ErrorBuilder builder) {
        this.statusCode = builder.statusCode;
        this.status = builder.status;
        this.simpleMessage = builder.simpleMessage;
        this.detailMessage = builder.detailMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @JsonSerialize(using=StatusSerialiser.class)
    public Status getStatus() {
        return this.status;
    }

    public String getSimpleMessage() {
        return this.simpleMessage;
    }

    public String getDetailMessage() {
        return this.detailMessage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        Error error = (Error)obj;
        return new EqualsBuilder().append(this.statusCode, error.statusCode).append((Object)this.simpleMessage, (Object)error.simpleMessage).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 31).append(this.statusCode).append((Object)this.simpleMessage).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("statusCode", this.statusCode).append("simpleMessage", (Object)this.simpleMessage).build();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class ErrorBuilder {
        private int statusCode;
        private Status status;
        private String simpleMessage;
        private String detailMessage;

        public ErrorBuilder statusCode(int statusCode) {
            this.statusCode = statusCode;
            this.status = Status.fromStatusCode(statusCode);
            return this;
        }

        @JsonDeserialize(using=StatusDeserialiser.class)
        public ErrorBuilder status(Status status) {
            this.status = status;
            this.statusCode = status.getStatusCode();
            return this;
        }

        public ErrorBuilder simpleMessage(String simpleMessage) {
            this.simpleMessage = simpleMessage;
            return this;
        }

        public ErrorBuilder detailMessage(String detailMessage) {
            this.detailMessage = detailMessage;
            return this;
        }

        public Error build() {
            return new Error(DebugUtil.checkDebugMode() ? this : this.detailMessage(null));
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("simpleMessage", (Object)this.simpleMessage).append("detailMessage", (Object)this.detailMessage).append("statusCode", this.statusCode).append("status", (Object)this.status).toString();
        }
    }
}

