/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.core.exception;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.gchq.gaffer.commonutil.exception.UnauthorisedException;
import uk.gov.gchq.gaffer.core.exception.Error;
import uk.gov.gchq.gaffer.core.exception.GafferCheckedException;
import uk.gov.gchq.gaffer.core.exception.GafferRuntimeException;
import uk.gov.gchq.gaffer.core.exception.GafferWrappedErrorRuntimeException;
import uk.gov.gchq.gaffer.core.exception.Status;

public final class ErrorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorFactory.class);

    private ErrorFactory() {
    }

    public static Error from(UnauthorisedException e) {
        LOGGER.error("Error: {}", (Object)e.getMessage(), (Object)e);
        return new Error.ErrorBuilder().status(Status.FORBIDDEN).simpleMessage(e.getMessage()).detailMessage(ExceptionUtils.getStackTrace((Throwable)e)).build();
    }

    public static Error from(GafferCheckedException gex) {
        LOGGER.error("Error: {}", (Object)gex.getMessage(), (Object)gex);
        return new Error.ErrorBuilder().status(gex.getStatus()).simpleMessage(gex.getMessage()).detailMessage(ExceptionUtils.getStackTrace((Throwable)gex)).build();
    }

    public static Error from(GafferRuntimeException gex) {
        LOGGER.error("Error: {}", (Object)gex.getMessage(), (Object)gex);
        return new Error.ErrorBuilder().status(gex.getStatus()).simpleMessage(gex.getMessage()).detailMessage(ExceptionUtils.getStackTrace((Throwable)gex)).build();
    }

    public static Error from(GafferWrappedErrorRuntimeException gex) {
        LOGGER.error("Error: {}", (Object)gex.getError().getSimpleMessage(), (Object)gex);
        return gex.getError();
    }

    public static Error from(Exception ex) {
        LOGGER.error("Error: {}", (Object)ex.getMessage(), (Object)ex);
        return new Error.ErrorBuilder().status(Status.INTERNAL_SERVER_ERROR).simpleMessage(ex.getMessage()).detailMessage(ExceptionUtils.getStackTrace((Throwable)ex)).build();
    }
}

