/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation;

import java.io.ByteArrayOutputStream;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.core.exception.GafferCheckedException;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.MultiSerialiserStorage;

public class MultiSerialiser
implements ToBytesSerialiser<Object> {
    private static final long serialVersionUID = 8206706506883696003L;
    private final MultiSerialiserStorage supportedSerialisers = new MultiSerialiserStorage();

    public void setSerialisers(List<MultiSerialiserStorage.SerialiserDetail> serialisers) throws GafferCheckedException {
        this.supportedSerialisers.setSerialiserDetails(serialisers);
    }

    public MultiSerialiser addSerialiser(byte key, ToBytesSerialiser serialiser, Class aClass) throws GafferCheckedException {
        this.supportedSerialisers.addSerialiserDetails(key, serialiser, aClass);
        return this;
    }

    public List<MultiSerialiserStorage.SerialiserDetail> getSerialisers() {
        return this.supportedSerialisers.getSerialiserDetails();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialise(Object object) throws SerialisationException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            byte key = this.supportedSerialisers.getKeyFromValue(object);
            byte[] bytes = this.nullCheck(this.supportedSerialisers.getSerialiserFromKey(key)).serialise(object);
            stream.write(key);
            stream.write(bytes);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (SerialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    private ToBytesSerialiser nullCheck(ToBytesSerialiser serialiser) throws SerialisationException {
        if (null == serialiser) {
            throw new SerialisationException(String.format("Serialiser for object type %s does not exist within the MultiSerialiser", Object.class));
        }
        return serialiser;
    }

    @Override
    public Object deserialise(byte[] bytes) throws SerialisationException {
        try {
            byte keyByte = bytes[0];
            ToBytesSerialiser serialiser = this.nullCheck(this.supportedSerialisers.getSerialiserFromKey(keyByte));
            return serialiser.deserialise(bytes, 1, bytes.length - 1);
        }
        catch (SerialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    @Override
    public Object deserialiseEmpty() throws SerialisationException {
        return null;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return this.supportedSerialisers.preservesObjectOrdering();
    }

    @Override
    public boolean isConsistent() {
        return this.supportedSerialisers.isConsistent();
    }

    @Override
    public boolean canHandle(Class clazz) {
        return this.supportedSerialisers.canHandle(clazz);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiSerialiser serialiser = (MultiSerialiser)obj;
        return new EqualsBuilder().append((Object)this.supportedSerialisers, (Object)serialiser.supportedSerialisers).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.supportedSerialisers).toHashCode();
    }
}

