/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.ordered.OrderedIntegerSerialiser;

public class OrderedFloatSerialiser
implements ToBytesSerialiser<Float> {
    private static final long serialVersionUID = 6829577492677279853L;
    private static final OrderedIntegerSerialiser INTEGER_SERIALISER = new OrderedIntegerSerialiser();

    @Override
    public byte[] serialise(Float object) {
        int i = Float.floatToRawIntBits(object.floatValue());
        i = i < 0 ? (i ^= 0xFFFFFFFF) : (i ^= Integer.MIN_VALUE);
        return INTEGER_SERIALISER.serialise(i);
    }

    @Override
    public Float deserialise(byte[] bytes) throws SerialisationException {
        int i = INTEGER_SERIALISER.deserialise(bytes);
        i = i < 0 ? (i ^= Integer.MIN_VALUE) : (i ^= 0xFFFFFFFF);
        return Float.valueOf(Float.intBitsToFloat(i));
    }

    @Override
    public Float deserialiseEmpty() {
        return null;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return true;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public boolean canHandle(Class clazz) {
        return Float.class.equals((Object)clazz);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return OrderedFloatSerialiser.class.getName().hashCode();
    }
}

