/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;

public class OrderedIntegerSerialiser
implements ToBytesSerialiser<Integer> {
    private static final long serialVersionUID = 5671653945533196758L;

    @Override
    public byte[] serialise(Integer object) {
        int index;
        Integer signedI = object ^ Integer.MIN_VALUE;
        int shift = 56;
        int prefix = signedI < 0 ? 255 : 0;
        for (index = 0; index < 4 && (signedI >> shift & 0xFF) == prefix; ++index) {
            shift -= 8;
        }
        byte[] ret = new byte[5 - index];
        ret[0] = (byte)(4 - index);
        for (index = 1; index < ret.length; ++index) {
            ret[index] = (byte)(signedI >> shift);
            shift -= 8;
        }
        if (signedI < 0) {
            ret[0] = (byte)(8 - ret[0]);
        }
        return ret;
    }

    @Override
    public Integer deserialise(byte[] bytes) throws SerialisationException {
        if (bytes[0] >= 0 && bytes[0] <= 8) {
            int i = 0;
            int shift = 0;
            for (int idx = bytes.length - 1; idx >= 1; --idx) {
                i = (int)((long)i + (((long)bytes[idx] & 0xFFL) << shift));
                shift += 8;
            }
            if (bytes[0] > 4) {
                i |= -1 << (8 - bytes[0] << 3);
            }
            return Integer.valueOf(i) ^ Integer.MIN_VALUE;
        }
        throw new SerialisationException("Unexpected length " + (0xFF & bytes[0]));
    }

    @Override
    public Integer deserialiseEmpty() {
        return null;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return true;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public boolean canHandle(Class clazz) {
        return Integer.class.equals((Object)clazz);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return OrderedIntegerSerialiser.class.getName().hashCode();
    }
}

