/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.ordered;

import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;

public class OrderedLongSerialiser
implements ToBytesSerialiser<Long> {
    private static final long serialVersionUID = -8948380879926929233L;

    @Override
    public byte[] serialise(Long object) {
        int index;
        Long signedL = object ^ Long.MIN_VALUE;
        int shift = 56;
        int prefix = signedL < 0L ? 255 : 0;
        for (index = 0; index < 8 && (signedL >> shift & 0xFFL) == (long)prefix; ++index) {
            shift -= 8;
        }
        byte[] ret = new byte[9 - index];
        ret[0] = (byte)(8 - index);
        for (index = 1; index < ret.length; ++index) {
            ret[index] = (byte)(signedL >> shift);
            shift -= 8;
        }
        if (signedL < 0L) {
            ret[0] = (byte)(16 - ret[0]);
        }
        return ret;
    }

    @Override
    public Long deserialise(byte[] bytes) throws SerialisationException {
        long l = 0L;
        int shift = 0;
        if (bytes[0] < 0 || bytes[0] > 16) {
            throw new SerialisationException("Unexpected length " + (0xFF & bytes[0]));
        }
        for (int i = bytes.length - 1; i >= 1; --i) {
            l += ((long)bytes[i] & 0xFFL) << shift;
            shift += 8;
        }
        if (bytes[0] > 8) {
            l |= -1L << (16 - bytes[0] << 3);
        }
        return l ^ Long.MIN_VALUE;
    }

    @Override
    public boolean canHandle(Class clazz) {
        return Long.class.equals((Object)clazz);
    }

    @Override
    public Long deserialiseEmpty() {
        return null;
    }

    @Override
    public boolean preservesObjectOrdering() {
        return true;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return OrderedLongSerialiser.class.getName().hashCode();
    }
}

