/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.implementation.raw;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.gov.gchq.gaffer.exception.SerialisationException;

public final class CompactRawSerialisationUtils {
    private CompactRawSerialisationUtils() {
    }

    public static byte[] writeLong(long l) {
        long value = l;
        if (value >= -112L && value <= 127L) {
            return new byte[]{(byte)value};
        }
        byte[] temp = new byte[9];
        int len = -112;
        if (value < 0L) {
            value ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = value;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        temp[0] = (byte)len;
        int place = 1;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftBits = (idx - 1) * 8;
            long mask = 255L << shiftBits;
            temp[place++] = (byte)((value & mask) >> shiftBits);
        }
        byte[] result = new byte[place];
        System.arraycopy(temp, 0, result, 0, place);
        return result;
    }

    public static long readLong(byte[] allBytes, int offset) throws SerialisationException {
        try {
            long rtn;
            int carriage = offset;
            byte firstByte = allBytes[carriage++];
            int len = CompactRawSerialisationUtils.decodeVIntSize(firstByte);
            if (len == 1) {
                rtn = firstByte;
            } else {
                rtn = 0L;
                int end = offset + len;
                while (carriage < end) {
                    byte b = allBytes[carriage++];
                    rtn <<= 8;
                    rtn |= (long)(b & 0xFF);
                }
                rtn = CompactRawSerialisationUtils.isNegativeVInt(firstByte) ? rtn ^ 0xFFFFFFFFFFFFFFFFL : rtn;
            }
            return rtn;
        }
        catch (Exception e) {
            throw new SerialisationException(e.getMessage(), e);
        }
    }

    public static long readLong(byte[] bytes) throws SerialisationException {
        return CompactRawSerialisationUtils.readLong(bytes, 0);
    }

    public static void write(long l, OutputStream output) throws SerialisationException {
        try {
            long value = l;
            if (value >= -112L && value <= 127L) {
                output.write((byte)value);
                return;
            }
            int len = -112;
            if (value < 0L) {
                value ^= 0xFFFFFFFFFFFFFFFFL;
                len = -120;
            }
            long tmp = value;
            while (tmp != 0L) {
                tmp >>= 8;
                --len;
            }
            output.write((byte)len);
            for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
                int shiftBits = (idx - 1) * 8;
                long mask = 255L << shiftBits;
                output.write((byte)((value & mask) >> shiftBits));
            }
        }
        catch (IOException e) {
            throw new SerialisationException("Exception reading bytes", e);
        }
    }

    public static long read(InputStream input) throws SerialisationException {
        try {
            byte firstByte = (byte)input.read();
            int len = CompactRawSerialisationUtils.decodeVIntSize(firstByte);
            if (len == 1) {
                return firstByte;
            }
            long i = 0L;
            for (int idx = 0; idx < len - 1; ++idx) {
                byte b = (byte)input.read();
                i <<= 8;
                i |= (long)(b & 0xFF);
            }
            return CompactRawSerialisationUtils.isNegativeVInt(firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
        }
        catch (IOException e) {
            throw new SerialisationException("Exception writing bytes", e);
        }
    }

    public static int decodeVIntSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }

    private static boolean isNegativeVInt(byte value) {
        return value < -120 || value >= -112 && value < 0;
    }
}

