/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.serialisation.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import uk.gov.gchq.gaffer.exception.SerialisationException;
import uk.gov.gchq.gaffer.serialisation.ToBytesSerialiser;
import uk.gov.gchq.gaffer.serialisation.implementation.raw.CompactRawSerialisationUtils;

public abstract class LengthValueBytesSerialiserUtil {
    private static final byte[] EMPTY_BYTES = new byte[0];

    public static ByteArrayOutputStream createByteArray() {
        return new ByteArrayOutputStream();
    }

    public static ByteArrayOutputStream appendLengthValueFromObjectToByteStream(ByteArrayOutputStream byteOut, ToBytesSerialiser serialiser, Object object) throws SerialisationException {
        Objects.requireNonNull(serialiser, "Given serialiser is null");
        return LengthValueBytesSerialiserUtil.appendLengthValueFromBytesToByteStream(byteOut, serialiser.serialise(object));
    }

    public static ByteArrayOutputStream appendLengthValueFromBytesToByteStream(ByteArrayOutputStream byteOut, byte[] serialisedObject) throws SerialisationException {
        CompactRawSerialisationUtils.write(serialisedObject.length, byteOut);
        try {
            byteOut.write(serialisedObject);
        }
        catch (IOException e) {
            throw new SerialisationException(e.getMessage(), e);
        }
        return byteOut;
    }

    public static <T> byte[] serialise(ToBytesSerialiser<T> serialiser, T value) throws SerialisationException {
        byte[] valueBytes = LengthValueBytesSerialiserUtil.getValueBytes(serialiser, value);
        return LengthValueBytesSerialiserUtil.serialise(valueBytes);
    }

    public static <T> void serialise(ToBytesSerialiser<T> serialiser, T value, ByteArrayOutputStream out) throws SerialisationException {
        byte[] valueBytes = LengthValueBytesSerialiserUtil.getValueBytes(serialiser, value);
        LengthValueBytesSerialiserUtil.serialise(valueBytes, out);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialise(byte[] valueBytes) throws SerialisationException {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            LengthValueBytesSerialiserUtil.serialise(valueBytes, byteStream);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new SerialisationException("Unable to write bytes to output stream", e);
        }
    }

    public static void serialise(byte[] valueBytes, ByteArrayOutputStream out) throws SerialisationException {
        if (null == valueBytes || 0 == valueBytes.length) {
            CompactRawSerialisationUtils.write(0L, out);
        } else {
            CompactRawSerialisationUtils.write(valueBytes.length, out);
            try {
                out.write(valueBytes);
            }
            catch (IOException e) {
                throw new SerialisationException("Unable to write bytes to output stream", e);
            }
        }
    }

    public static <T> T deserialise(ToBytesSerialiser<T> serialiser, byte[] allBytes) throws SerialisationException {
        return LengthValueBytesSerialiserUtil.deserialise(serialiser, allBytes, 0);
    }

    public static <T> T deserialise(ToBytesSerialiser<T> serialiser, byte[] allBytes, int delimiter) throws SerialisationException {
        return LengthValueBytesSerialiserUtil.getValue(serialiser, LengthValueBytesSerialiserUtil.deserialise(allBytes, delimiter));
    }

    public static <T> T deserialise(ToBytesSerialiser<T> serialiser, byte[] allBytes, int[] delimiterWrapper) throws SerialisationException {
        return LengthValueBytesSerialiserUtil.getValue(serialiser, LengthValueBytesSerialiserUtil.deserialise(allBytes, delimiterWrapper));
    }

    public static byte[] deserialise(byte[] allBytes, int[] delimiterWrapper) throws SerialisationException {
        if (1 != delimiterWrapper.length) {
            throw new IllegalArgumentException("Delimiter wrapper must always be a int array of length 1 containing the delimiter");
        }
        int lengthSize = LengthValueBytesSerialiserUtil.getLengthSize(allBytes, delimiterWrapper[0]);
        int valueSize = LengthValueBytesSerialiserUtil.getValueSize(allBytes, lengthSize, delimiterWrapper[0]);
        byte[] valueBytes = LengthValueBytesSerialiserUtil.deserialise(allBytes, lengthSize, valueSize, delimiterWrapper[0]);
        delimiterWrapper[0] = LengthValueBytesSerialiserUtil.getNextDelimiter(lengthSize, valueSize, delimiterWrapper[0]);
        return valueBytes;
    }

    public static byte[] deserialise(byte[] allBytes) throws SerialisationException {
        return LengthValueBytesSerialiserUtil.deserialise(allBytes, 0);
    }

    public static byte[] deserialise(byte[] allBytes, int delimiter) throws SerialisationException {
        if (null == allBytes || 0 == allBytes.length) {
            return new byte[0];
        }
        int lengthSize = LengthValueBytesSerialiserUtil.getLengthSize(allBytes, delimiter);
        int valueSize = LengthValueBytesSerialiserUtil.getValueSize(allBytes, lengthSize, delimiter);
        return LengthValueBytesSerialiserUtil.deserialise(allBytes, lengthSize, valueSize, delimiter);
    }

    public static byte[] deserialise(byte[] allBytes, int lengthSize, int valueSize, int delimiter) throws SerialisationException {
        if (null == allBytes || 0 == allBytes.length) {
            return new byte[0];
        }
        return Arrays.copyOfRange(allBytes, delimiter + lengthSize, delimiter + lengthSize + valueSize);
    }

    public static int getLengthSize(byte[] allBytes, int delimiter) throws SerialisationException {
        return CompactRawSerialisationUtils.decodeVIntSize(allBytes[delimiter]);
    }

    public static int getValueSize(byte[] allBytes, int delimiter) throws SerialisationException {
        return LengthValueBytesSerialiserUtil.getValueSize(allBytes, LengthValueBytesSerialiserUtil.getLengthSize(allBytes, delimiter), delimiter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getValueSize(byte[] allBytes, int lengthSize, int delimiter) throws SerialisationException {
        try (ByteArrayInputStream input = new ByteArrayInputStream(allBytes, delimiter, lengthSize);){
            int n = (int)CompactRawSerialisationUtils.read(input);
            return n;
        }
        catch (IOException e) {
            throw new SerialisationException("Exception reading length of property", e);
        }
    }

    public static int getNextDelimiter(byte[] allBytes, int delimiter) throws SerialisationException {
        int lengthSize = LengthValueBytesSerialiserUtil.getLengthSize(allBytes, delimiter);
        int valueSize = LengthValueBytesSerialiserUtil.getValueSize(allBytes, lengthSize, delimiter);
        return LengthValueBytesSerialiserUtil.getNextDelimiter(lengthSize, valueSize, delimiter);
    }

    public static int getNextDelimiter(byte[] allBytes, byte[] valueBytes, int lastDelimiter) {
        return LengthValueBytesSerialiserUtil.getNextDelimiter(allBytes, valueBytes.length, lastDelimiter);
    }

    public static int getNextDelimiter(byte[] allBytes, int valueSize, int lastDelimiter) {
        return LengthValueBytesSerialiserUtil.getNextDelimiter(CompactRawSerialisationUtils.decodeVIntSize(allBytes[lastDelimiter]), valueSize, lastDelimiter);
    }

    public static int getNextDelimiter(int lengthSize, int valueSize, int lastDelimiter) {
        return lastDelimiter + lengthSize + valueSize;
    }

    public static <T> byte[] getValueBytes(ToBytesSerialiser<T> serialiser, T value) throws SerialisationException {
        byte[] valueBytes = null == serialiser ? EMPTY_BYTES : (null == value ? serialiser.serialiseNull() : serialiser.serialise(value));
        return valueBytes;
    }

    private static <T> T getValue(ToBytesSerialiser<T> serialiser, byte[] valueBytes) throws SerialisationException {
        if (0 == valueBytes.length) {
            return serialiser.deserialiseEmpty();
        }
        return serialiser.deserialise(valueBytes);
    }

    public static <T> ObjectCarriage<T> deserialiseNextObject(ToBytesSerialiser<T> serialiser, int currentCarriage, byte[] bytes) throws SerialisationException {
        int rtn = currentCarriage;
        int numBytesForLength = CompactRawSerialisationUtils.decodeVIntSize(bytes[rtn]);
        int currentPropLength = LengthValueBytesSerialiserUtil.getCurrentPropLength(bytes, rtn, numBytesForLength);
        int from = rtn += numBytesForLength;
        int to = rtn += currentPropLength;
        T object = serialiser.deserialise(Arrays.copyOfRange(bytes, from, to));
        return new ObjectCarriage<T>(object, rtn);
    }

    private static int getCurrentPropLength(byte[] bytes, int pos, int numBytesForLength) throws SerialisationException {
        byte[] length = new byte[numBytesForLength];
        System.arraycopy(bytes, pos, length, 0, numBytesForLength);
        return (int)CompactRawSerialisationUtils.readLong(length);
    }

    public static class LengthValueBuilder {
        ByteArrayOutputStream byteOut = LengthValueBytesSerialiserUtil.createByteArray();

        public LengthValueBuilder appendLengthValueFromObjectToByteStream(ToBytesSerialiser serialiser, Object object) throws SerialisationException {
            LengthValueBytesSerialiserUtil.appendLengthValueFromObjectToByteStream(this.byteOut, serialiser, object);
            return this;
        }

        public LengthValueBuilder appendLengthValueFromBytesToByteStream(byte[] serialisedObject) throws SerialisationException {
            LengthValueBytesSerialiserUtil.appendLengthValueFromBytesToByteStream(this.byteOut, serialisedObject);
            return this;
        }

        public byte[] toArray() {
            return this.byteOut.toByteArray();
        }
    }

    public static class ObjectCarriage<T> {
        private T object;
        private int carriage;

        ObjectCarriage(T object, int carriage) {
            this.object = object;
            this.carriage = carriage;
        }

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }

        public int getCarriage() {
            return this.carriage;
        }

        public void setCarriage(int carriage) {
            this.carriage = carriage;
        }
    }
}

